/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.TokenSeparatorGenerator;
import com.intellij.psi.PsiManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LanguageTokenSeparatorGenerators
extends LanguageExtension<TokenSeparatorGenerator> {
    public static final LanguageTokenSeparatorGenerators INSTANCE = new LanguageTokenSeparatorGenerators();

    private LanguageTokenSeparatorGenerators() {
        super("com.intellij.lang.tokenSeparatorGenerator", new DefaultTokenSeparatorGenerator());
    }

    public static class DefaultTokenSeparatorGenerator
    implements TokenSeparatorGenerator {
        @Override
        public ASTNode generateWhitespaceBetweenTokens(@Nullable ASTNode left, @NotNull ASTNode right) {
            ParserDefinition parserDefinition;
            if (right == null) {
                DefaultTokenSeparatorGenerator.$$$reportNull$$$0(0);
            }
            Language leftLang = PsiUtilCore.getNotAnyLanguage(left);
            Language rightLang = PsiUtilCore.getNotAnyLanguage(right);
            if (rightLang.isKindOf(leftLang)) {
                leftLang = rightLang;
            }
            if ((parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(leftLang)) != null) {
                LeafElement generatedWhitespace;
                switch (parserDefinition.spaceExistenceTypeBetweenTokens(left, right)) {
                    case MUST: {
                        generatedWhitespace = this.createWhiteSpace(left, right);
                        break;
                    }
                    case MUST_LINE_BREAK: {
                        generatedWhitespace = this.createNewLine(left, right);
                        break;
                    }
                    default: {
                        generatedWhitespace = null;
                    }
                }
                return generatedWhitespace;
            }
            return null;
        }

        @NotNull
        protected LeafElement createNewLine(@Nullable ASTNode left, @NotNull ASTNode right) {
            if (right == null) {
                DefaultTokenSeparatorGenerator.$$$reportNull$$$0(1);
            }
            PsiManager manager = right.getTreeParent().getPsi().getManager();
            LeafElement leafElement = Factory.createSingleLeafElement(TokenType.WHITE_SPACE, "\n", 0, 1, null, manager);
            if (leafElement == null) {
                DefaultTokenSeparatorGenerator.$$$reportNull$$$0(2);
            }
            return leafElement;
        }

        @NotNull
        protected LeafElement createWhiteSpace(@Nullable ASTNode left, @NotNull ASTNode right) {
            if (right == null) {
                DefaultTokenSeparatorGenerator.$$$reportNull$$$0(3);
            }
            PsiManager manager = right.getTreeParent().getPsi().getManager();
            LeafElement leafElement = Factory.createSingleLeafElement(TokenType.WHITE_SPACE, " ", 0, 1, null, manager);
            if (leafElement == null) {
                DefaultTokenSeparatorGenerator.$$$reportNull$$$0(4);
            }
            return leafElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/LanguageTokenSeparatorGenerators$DefaultTokenSeparatorGenerator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/LanguageTokenSeparatorGenerators$DefaultTokenSeparatorGenerator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNewLine";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createWhiteSpace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generateWhitespaceBetweenTokens";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createNewLine";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createWhiteSpace";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

