/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.core.CoreBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginNonLoadReason;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\u00070\u0005\u00a2\u0006\u0002\b\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000bR\u0019\u0010\u000f\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000bR\u0019\u0010\u0012\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000bR\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ide/plugins/PluginHasDuplicateContentModuleDeclaration;", "Lcom/intellij/ide/plugins/PluginNonLoadReason;", "plugin", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "moduleId", "", "<init>", "(Lcom/intellij/ide/plugins/IdeaPluginDescriptor;Ljava/lang/String;)V", "getPlugin", "()Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "getModuleId", "()Ljava/lang/String;", "detailedMessage", "Lcom/intellij/openapi/util/NlsContexts$DetailedDescription;", "getDetailedMessage", "shortMessage", "Lcom/intellij/openapi/util/NlsContexts$Label;", "getShortMessage", "logMessage", "Lorg/jetbrains/annotations/NonNls;", "getLogMessage", "shouldNotifyUser", "", "getShouldNotifyUser", "()Z", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class PluginHasDuplicateContentModuleDeclaration
implements PluginNonLoadReason {
    @NotNull
    private final IdeaPluginDescriptor plugin;
    @NotNull
    private final String moduleId;

    public PluginHasDuplicateContentModuleDeclaration(@NotNull IdeaPluginDescriptor plugin, @NotNull String moduleId) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)moduleId, (String)"moduleId");
        this.plugin = plugin;
        this.moduleId = moduleId;
    }

    @Override
    @NotNull
    public IdeaPluginDescriptor getPlugin() {
        return this.plugin;
    }

    @NotNull
    public final String getModuleId() {
        return this.moduleId;
    }

    @Override
    @NotNull
    public String getDetailedMessage() {
        Object[] objectArray = new Object[]{this.getPlugin().getName(), this.moduleId};
        String string = CoreBundle.message("plugin.loading.error.long.content.modules.are.invalid.duplicate.module", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    public String getShortMessage() {
        Object[] objectArray = new Object[]{this.getPlugin().getName()};
        String string = CoreBundle.message("plugin.loading.error.short.content.modules.are.invalid.duplicate.module", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    public String getLogMessage() {
        return "Plugin '" + this.getPlugin().getName() + "' (" + this.getPlugin().getPluginId() + ") has duplicate declaration of content module '" + this.moduleId + '\'';
    }

    @Override
    public boolean getShouldNotifyUser() {
        return true;
    }
}

