/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.comparison.ComparisonMergeUtil;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.fragments.MergeWordFragment;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.util.DiffRangeUtil;
import com.intellij.diff.util.MergeConflictResolutionStrategy;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.ThreeSide;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J`\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u000b2\u001a\u0010\f\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0007J4\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J4\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J,\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0013H\u0002JD\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\bH\u0002J\u0018\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\bH\u0002J&\u0010 \u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J6\u0010#\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\bH\u0007J\u0018\u0010$\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020!2\u0006\u0010\u001f\u001a\u00020\bH\u0002J4\u0010%\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J6\u0010&\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002\u00a8\u0006'"}, d2={"Lcom/intellij/diff/util/MergeRangeUtil;", "", "<init>", "()V", "getMergeType", "Lcom/intellij/diff/util/MergeConflictType;", "emptiness", "Lkotlin/Function1;", "Lcom/intellij/diff/util/ThreeSide;", "", "equality", "Lkotlin/Function2;", "trueEquality", "conflictResolver", "Lkotlin/Function0;", "getLineThreeWayDiffType", "fragment", "Lcom/intellij/diff/fragments/MergeLineFragment;", "sequences", "", "", "lineOffsets", "Lcom/intellij/diff/tools/util/text/LineOffsets;", "policy", "Lcom/intellij/diff/comparison/ComparisonPolicy;", "getLineMergeType", "canResolveLineConflict", "compareLineMergeContents", "side1", "side2", "isLineMergeIntervalEmpty", "side", "getWordMergeType", "Lcom/intellij/diff/fragments/MergeWordFragment;", "texts", "compareWordMergeContents", "isWordMergeIntervalEmpty", "getLineLeftToRightThreeSideDiffType", "getLeftToRightDiffType", "intellij.platform.util.diff"})
public final class MergeRangeUtil {
    @NotNull
    public static final MergeRangeUtil INSTANCE = new MergeRangeUtil();

    private MergeRangeUtil() {
    }

    @JvmStatic
    @NotNull
    public static final MergeConflictType getMergeType(@NotNull Function1<? super ThreeSide, Boolean> emptiness, @NotNull Function2<? super ThreeSide, ? super ThreeSide, Boolean> equality, @Nullable Function2<? super ThreeSide, ? super ThreeSide, Boolean> trueEquality, @NotNull Function0<Boolean> conflictResolver) {
        Intrinsics.checkNotNullParameter(emptiness, (String)"emptiness");
        Intrinsics.checkNotNullParameter(equality, (String)"equality");
        Intrinsics.checkNotNullParameter(conflictResolver, (String)"conflictResolver");
        boolean isLeftEmpty = (Boolean)emptiness.invoke((Object)ThreeSide.LEFT);
        boolean isBaseEmpty = (Boolean)emptiness.invoke((Object)ThreeSide.BASE);
        boolean isRightEmpty = (Boolean)emptiness.invoke((Object)ThreeSide.RIGHT);
        if (!(!isLeftEmpty || !isBaseEmpty || !isRightEmpty)) {
            throw new IllegalStateException("Check failed.");
        }
        if (isBaseEmpty) {
            if (isLeftEmpty) {
                return new MergeConflictType(MergeConflictType.Type.INSERTED, false, true, null, 8, null);
            }
            if (isRightEmpty) {
                return new MergeConflictType(MergeConflictType.Type.INSERTED, true, false, null, 8, null);
            }
            boolean equalModifications = (Boolean)equality.invoke((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
            if (equalModifications) {
                return new MergeConflictType(MergeConflictType.Type.INSERTED, true, true, null, 8, null);
            }
            return new MergeConflictType(MergeConflictType.Type.CONFLICT, true, true, null);
        }
        if (isLeftEmpty && isRightEmpty) {
            return new MergeConflictType(MergeConflictType.Type.DELETED, true, true, null, 8, null);
        }
        boolean unchangedLeft = (Boolean)equality.invoke((Object)ThreeSide.BASE, (Object)ThreeSide.LEFT);
        boolean unchangedRight = (Boolean)equality.invoke((Object)ThreeSide.BASE, (Object)ThreeSide.RIGHT);
        if (unchangedLeft && unchangedRight) {
            if (trueEquality == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            boolean trueUnchangedLeft = (Boolean)trueEquality.invoke((Object)ThreeSide.BASE, (Object)ThreeSide.LEFT);
            boolean trueUnchangedRight = (Boolean)trueEquality.invoke((Object)ThreeSide.BASE, (Object)ThreeSide.RIGHT);
            if (!(!trueUnchangedLeft || !trueUnchangedRight)) {
                throw new IllegalStateException("Check failed.");
            }
            return new MergeConflictType(MergeConflictType.Type.MODIFIED, !trueUnchangedLeft, !trueUnchangedRight, null, 8, null);
        }
        if (unchangedLeft) {
            return new MergeConflictType(isRightEmpty ? MergeConflictType.Type.DELETED : MergeConflictType.Type.MODIFIED, false, true, null, 8, null);
        }
        if (unchangedRight) {
            return new MergeConflictType(isLeftEmpty ? MergeConflictType.Type.DELETED : MergeConflictType.Type.MODIFIED, true, false, null, 8, null);
        }
        boolean equalModifications = (Boolean)equality.invoke((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
        if (equalModifications) {
            return new MergeConflictType(MergeConflictType.Type.MODIFIED, true, true, null, 8, null);
        }
        boolean canBeResolved = !isLeftEmpty && !isRightEmpty && (Boolean)conflictResolver.invoke() != false;
        return new MergeConflictType(MergeConflictType.Type.CONFLICT, true, true, canBeResolved ? MergeConflictResolutionStrategy.TEXT : null);
    }

    @JvmStatic
    @NotNull
    public static final MergeConflictType getLineThreeWayDiffType(@NotNull MergeLineFragment fragment, @NotNull List<? extends CharSequence> sequences, @NotNull List<? extends LineOffsets> lineOffsets, @NotNull ComparisonPolicy policy) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter(sequences, (String)"sequences");
        Intrinsics.checkNotNullParameter(lineOffsets, (String)"lineOffsets");
        Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
        return MergeRangeUtil.getMergeType((Function1<? super ThreeSide, Boolean>)((Function1)arg_0 -> MergeRangeUtil.getLineThreeWayDiffType$lambda$0(fragment, arg_0)), (Function2<? super ThreeSide, ? super ThreeSide, Boolean>)((Function2)(arg_0, arg_1) -> MergeRangeUtil.getLineThreeWayDiffType$lambda$1(fragment, sequences, lineOffsets, policy, arg_0, arg_1)), null, (Function0<Boolean>)((Function0)() -> MergeRangeUtil.getLineThreeWayDiffType$lambda$2(fragment, sequences, lineOffsets)));
    }

    @JvmStatic
    @NotNull
    public static final MergeConflictType getLineMergeType(@NotNull MergeLineFragment fragment, @NotNull List<? extends CharSequence> sequences, @NotNull List<? extends LineOffsets> lineOffsets, @NotNull ComparisonPolicy policy) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter(sequences, (String)"sequences");
        Intrinsics.checkNotNullParameter(lineOffsets, (String)"lineOffsets");
        Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
        return MergeRangeUtil.getMergeType((Function1<? super ThreeSide, Boolean>)((Function1)arg_0 -> MergeRangeUtil.getLineMergeType$lambda$3(fragment, arg_0)), (Function2<? super ThreeSide, ? super ThreeSide, Boolean>)((Function2)(arg_0, arg_1) -> MergeRangeUtil.getLineMergeType$lambda$4(fragment, sequences, lineOffsets, policy, arg_0, arg_1)), (Function2<? super ThreeSide, ? super ThreeSide, Boolean>)((Function2)(arg_0, arg_1) -> MergeRangeUtil.getLineMergeType$lambda$5(fragment, sequences, lineOffsets, arg_0, arg_1)), (Function0<Boolean>)((Function0)() -> MergeRangeUtil.getLineMergeType$lambda$6(fragment, sequences, lineOffsets)));
    }

    private final boolean canResolveLineConflict(MergeLineFragment fragment, List<? extends CharSequence> sequences, List<? extends LineOffsets> lineOffsets) {
        List contents = ThreeSide.Companion.map(arg_0 -> MergeRangeUtil.canResolveLineConflict$lambda$7(sequences, lineOffsets, fragment, arg_0));
        return ComparisonMergeUtil.tryResolveConflict((CharSequence)contents.get(0), (CharSequence)contents.get(1), (CharSequence)contents.get(2)) != null;
    }

    private final boolean compareLineMergeContents(MergeLineFragment fragment, List<? extends CharSequence> sequences, List<? extends LineOffsets> lineOffsets, ComparisonPolicy policy, ThreeSide side1, ThreeSide side2) {
        int start1 = fragment.getStartLine(side1);
        int end1 = fragment.getEndLine(side1);
        int start2 = fragment.getStartLine(side2);
        int end2 = fragment.getEndLine(side2);
        if (end2 - start2 != end1 - start1) {
            return false;
        }
        CharSequence sequence1 = side1.selectNotNull(sequences);
        CharSequence sequence2 = side2.selectNotNull(sequences);
        LineOffsets offsets1 = side1.selectNotNull(lineOffsets);
        LineOffsets offsets2 = side2.selectNotNull(lineOffsets);
        int n = end1 - start1;
        for (int i = 0; i < n; ++i) {
            CharSequence content2;
            int line1 = start1 + i;
            int line2 = start2 + i;
            CharSequence content1 = DiffRangeUtil.getLinesContent(sequence1, offsets1, line1, line1 + 1);
            if (ComparisonUtil.isEqualTexts(content1, content2 = DiffRangeUtil.getLinesContent(sequence2, offsets2, line2, line2 + 1), policy)) continue;
            return false;
        }
        return true;
    }

    private final boolean isLineMergeIntervalEmpty(MergeLineFragment fragment, ThreeSide side) {
        return fragment.getStartLine(side) == fragment.getEndLine(side);
    }

    @JvmStatic
    @NotNull
    public static final MergeConflictType getWordMergeType(@NotNull MergeWordFragment fragment, @NotNull List<? extends CharSequence> texts, @NotNull ComparisonPolicy policy) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter(texts, (String)"texts");
        Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
        return MergeRangeUtil.getMergeType((Function1<? super ThreeSide, Boolean>)((Function1)arg_0 -> MergeRangeUtil.getWordMergeType$lambda$8(fragment, arg_0)), (Function2<? super ThreeSide, ? super ThreeSide, Boolean>)((Function2)(arg_0, arg_1) -> MergeRangeUtil.getWordMergeType$lambda$9(fragment, texts, policy, arg_0, arg_1)), null, (Function0<Boolean>)((Function0)MergeRangeUtil::getWordMergeType$lambda$10));
    }

    @JvmStatic
    public static final boolean compareWordMergeContents(@NotNull MergeWordFragment fragment, @NotNull List<? extends CharSequence> texts, @NotNull ComparisonPolicy policy, @NotNull ThreeSide side1, @NotNull ThreeSide side2) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter(texts, (String)"texts");
        Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
        Intrinsics.checkNotNullParameter((Object)((Object)side1), (String)"side1");
        Intrinsics.checkNotNullParameter((Object)((Object)side2), (String)"side2");
        int start1 = fragment.getStartOffset(side1);
        int end1 = fragment.getEndOffset(side1);
        int start2 = fragment.getStartOffset(side2);
        int end2 = fragment.getEndOffset(side2);
        CharSequence document1 = side1.selectNotNull(texts);
        CharSequence document2 = side2.selectNotNull(texts);
        CharSequence content1 = document1.subSequence(start1, end1);
        CharSequence content2 = document2.subSequence(start2, end2);
        return ComparisonUtil.isEqualTexts(content1, content2, policy);
    }

    private final boolean isWordMergeIntervalEmpty(MergeWordFragment fragment, ThreeSide side) {
        return fragment.getStartOffset(side) == fragment.getEndOffset(side);
    }

    @JvmStatic
    @NotNull
    public static final MergeConflictType getLineLeftToRightThreeSideDiffType(@NotNull MergeLineFragment fragment, @NotNull List<? extends CharSequence> sequences, @NotNull List<? extends LineOffsets> lineOffsets, @NotNull ComparisonPolicy policy) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter(sequences, (String)"sequences");
        Intrinsics.checkNotNullParameter(lineOffsets, (String)"lineOffsets");
        Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
        return INSTANCE.getLeftToRightDiffType((Function1<? super ThreeSide, Boolean>)((Function1)arg_0 -> MergeRangeUtil.getLineLeftToRightThreeSideDiffType$lambda$11(fragment, arg_0)), (Function2<? super ThreeSide, ? super ThreeSide, Boolean>)((Function2)(arg_0, arg_1) -> MergeRangeUtil.getLineLeftToRightThreeSideDiffType$lambda$12(fragment, sequences, lineOffsets, policy, arg_0, arg_1)));
    }

    private final MergeConflictType getLeftToRightDiffType(Function1<? super ThreeSide, Boolean> emptiness, Function2<? super ThreeSide, ? super ThreeSide, Boolean> equality) {
        boolean isLeftEmpty = (Boolean)emptiness.invoke((Object)ThreeSide.LEFT);
        boolean isBaseEmpty = (Boolean)emptiness.invoke((Object)ThreeSide.BASE);
        boolean isRightEmpty = (Boolean)emptiness.invoke((Object)ThreeSide.RIGHT);
        if (!(!isLeftEmpty || !isBaseEmpty || !isRightEmpty)) {
            throw new IllegalStateException("Check failed.");
        }
        if (isBaseEmpty) {
            if (isLeftEmpty) {
                return new MergeConflictType(MergeConflictType.Type.INSERTED, false, true, null, 8, null);
            }
            if (isRightEmpty) {
                return new MergeConflictType(MergeConflictType.Type.DELETED, true, false, null, 8, null);
            }
            return new MergeConflictType(MergeConflictType.Type.MODIFIED, true, true, null, 8, null);
        }
        if (isLeftEmpty && isRightEmpty) {
            return new MergeConflictType(MergeConflictType.Type.MODIFIED, true, true, null, 8, null);
        }
        boolean unchangedLeft = (Boolean)equality.invoke((Object)ThreeSide.BASE, (Object)ThreeSide.LEFT);
        boolean unchangedRight = (Boolean)equality.invoke((Object)ThreeSide.BASE, (Object)ThreeSide.RIGHT);
        if (!(!unchangedLeft || !unchangedRight)) {
            throw new IllegalStateException("Check failed.");
        }
        if (unchangedLeft) {
            return new MergeConflictType(isRightEmpty ? MergeConflictType.Type.DELETED : MergeConflictType.Type.MODIFIED, false, true, null, 8, null);
        }
        if (unchangedRight) {
            return new MergeConflictType(isLeftEmpty ? MergeConflictType.Type.INSERTED : MergeConflictType.Type.MODIFIED, true, false, null, 8, null);
        }
        return new MergeConflictType(MergeConflictType.Type.MODIFIED, true, true, null, 8, null);
    }

    private static final boolean getLineThreeWayDiffType$lambda$0(MergeLineFragment $fragment, ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
        return INSTANCE.isLineMergeIntervalEmpty($fragment, side);
    }

    private static final boolean getLineThreeWayDiffType$lambda$1(MergeLineFragment $fragment, List $sequences, List $lineOffsets, ComparisonPolicy $policy, ThreeSide side1, ThreeSide side2) {
        Intrinsics.checkNotNullParameter((Object)((Object)side1), (String)"side1");
        Intrinsics.checkNotNullParameter((Object)((Object)side2), (String)"side2");
        return INSTANCE.compareLineMergeContents($fragment, $sequences, $lineOffsets, $policy, side1, side2);
    }

    private static final boolean getLineThreeWayDiffType$lambda$2(MergeLineFragment $fragment, List $sequences, List $lineOffsets) {
        return INSTANCE.canResolveLineConflict($fragment, $sequences, $lineOffsets);
    }

    private static final boolean getLineMergeType$lambda$3(MergeLineFragment $fragment, ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
        return INSTANCE.isLineMergeIntervalEmpty($fragment, side);
    }

    private static final boolean getLineMergeType$lambda$4(MergeLineFragment $fragment, List $sequences, List $lineOffsets, ComparisonPolicy $policy, ThreeSide side1, ThreeSide side2) {
        Intrinsics.checkNotNullParameter((Object)((Object)side1), (String)"side1");
        Intrinsics.checkNotNullParameter((Object)((Object)side2), (String)"side2");
        return INSTANCE.compareLineMergeContents($fragment, $sequences, $lineOffsets, $policy, side1, side2);
    }

    private static final boolean getLineMergeType$lambda$5(MergeLineFragment $fragment, List $sequences, List $lineOffsets, ThreeSide side1, ThreeSide side2) {
        Intrinsics.checkNotNullParameter((Object)((Object)side1), (String)"side1");
        Intrinsics.checkNotNullParameter((Object)((Object)side2), (String)"side2");
        return INSTANCE.compareLineMergeContents($fragment, $sequences, $lineOffsets, ComparisonPolicy.DEFAULT, side1, side2);
    }

    private static final boolean getLineMergeType$lambda$6(MergeLineFragment $fragment, List $sequences, List $lineOffsets) {
        return INSTANCE.canResolveLineConflict($fragment, $sequences, $lineOffsets);
    }

    private static final CharSequence canResolveLineConflict$lambda$7(List $sequences, List $lineOffsets, MergeLineFragment $fragment, ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
        return DiffRangeUtil.getLinesContent((CharSequence)side.selectNotNull($sequences), (LineOffsets)side.selectNotNull($lineOffsets), $fragment.getStartLine(side), $fragment.getEndLine(side));
    }

    private static final boolean getWordMergeType$lambda$8(MergeWordFragment $fragment, ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
        return INSTANCE.isWordMergeIntervalEmpty($fragment, side);
    }

    private static final boolean getWordMergeType$lambda$9(MergeWordFragment $fragment, List $texts, ComparisonPolicy $policy, ThreeSide side1, ThreeSide side2) {
        Intrinsics.checkNotNullParameter((Object)((Object)side1), (String)"side1");
        Intrinsics.checkNotNullParameter((Object)((Object)side2), (String)"side2");
        return MergeRangeUtil.compareWordMergeContents($fragment, $texts, $policy, side1, side2);
    }

    private static final boolean getWordMergeType$lambda$10() {
        return false;
    }

    private static final boolean getLineLeftToRightThreeSideDiffType$lambda$11(MergeLineFragment $fragment, ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
        return INSTANCE.isLineMergeIntervalEmpty($fragment, side);
    }

    private static final boolean getLineLeftToRightThreeSideDiffType$lambda$12(MergeLineFragment $fragment, List $sequences, List $lineOffsets, ComparisonPolicy $policy, ThreeSide side1, ThreeSide side2) {
        Intrinsics.checkNotNullParameter((Object)((Object)side1), (String)"side1");
        Intrinsics.checkNotNullParameter((Object)((Object)side2), (String)"side2");
        return INSTANCE.compareLineMergeContents($fragment, $sequences, $lineOffsets, $policy, side1, side2);
    }
}

