/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.util.LinesRange;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0007J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0007J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0007J#\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00052\u000b\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\u0014H\u0007J3\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00052\u000b\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\u00142\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nH\u0007\u00a8\u0006\u0017"}, d2={"Lcom/intellij/diff/util/DiffRangeUtil;", "", "<init>", "()V", "getLinesContent", "", "sequence", "lineOffsets", "Lcom/intellij/diff/tools/util/text/LineOffsets;", "line1", "", "line2", "includeNewline", "", "getLinesRange", "Lcom/intellij/diff/util/LinesRange;", "getLines", "", "", "text", "Lorg/jetbrains/annotations/NonNls;", "startLine", "endLine", "intellij.platform.util.diff"})
public final class DiffRangeUtil {
    @NotNull
    public static final DiffRangeUtil INSTANCE = new DiffRangeUtil();

    private DiffRangeUtil() {
    }

    @JvmStatic
    @NotNull
    public static final CharSequence getLinesContent(@NotNull CharSequence sequence, @NotNull LineOffsets lineOffsets, int line1, int line2) {
        Intrinsics.checkNotNullParameter((Object)sequence, (String)"sequence");
        Intrinsics.checkNotNullParameter((Object)lineOffsets, (String)"lineOffsets");
        return DiffRangeUtil.getLinesContent(sequence, lineOffsets, line1, line2, false);
    }

    @JvmStatic
    @NotNull
    public static final CharSequence getLinesContent(@NotNull CharSequence sequence, @NotNull LineOffsets lineOffsets, int line1, int line2, boolean includeNewline) {
        Intrinsics.checkNotNullParameter((Object)sequence, (String)"sequence");
        Intrinsics.checkNotNullParameter((Object)lineOffsets, (String)"lineOffsets");
        if (!(sequence.length() == lineOffsets.getTextLength())) {
            throw new IllegalStateException("Check failed.");
        }
        LinesRange linesRange = DiffRangeUtil.getLinesRange(lineOffsets, line1, line2, includeNewline);
        return sequence.subSequence(linesRange.getStartOffset(), linesRange.getEndOffset());
    }

    @JvmStatic
    @NotNull
    public static final LinesRange getLinesRange(@NotNull LineOffsets lineOffsets, int line1, int line2, boolean includeNewline) {
        LinesRange linesRange;
        Intrinsics.checkNotNullParameter((Object)lineOffsets, (String)"lineOffsets");
        if (line1 == line2) {
            int lineStartOffset = line1 < lineOffsets.getLineCount() ? lineOffsets.getLineStart(line1) : lineOffsets.getTextLength();
            linesRange = new LinesRange(lineStartOffset, lineStartOffset);
        } else {
            int startOffset = lineOffsets.getLineStart(line1);
            int endOffset = lineOffsets.getLineEnd(line2 - 1);
            if (includeNewline && endOffset < lineOffsets.getTextLength()) {
                ++endOffset;
            }
            linesRange = new LinesRange(startOffset, endOffset);
        }
        return linesRange;
    }

    @JvmStatic
    @NotNull
    public static final List<String> getLines(@NotNull CharSequence text, @NotNull LineOffsets lineOffsets) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)lineOffsets, (String)"lineOffsets");
        return DiffRangeUtil.getLines(text, lineOffsets, 0, lineOffsets.getLineCount());
    }

    @JvmStatic
    @NotNull
    public static final List<String> getLines(@NotNull CharSequence text, @NotNull LineOffsets lineOffsets, int startLine, int endLine) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)lineOffsets, (String)"lineOffsets");
        if (startLine < 0 || startLine > endLine || endLine > lineOffsets.getLineCount()) {
            throw new IndexOutOfBoundsException("Wrong line range: [" + startLine + ", " + endLine + "); lineCount: '" + lineOffsets.getLineCount() + '\'');
        }
        List result = new ArrayList();
        for (int i = startLine; i < endLine; ++i) {
            int start = lineOffsets.getLineStart(i);
            int end = lineOffsets.getLineEnd(i);
            result.add(((Object)text.subSequence(start, end)).toString());
        }
        return result;
    }
}

