/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RefUtil {
    private RefUtil() {
    }

    public static boolean isImplicitUsage(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        for (ImplicitUsageProvider provider : ImplicitUsageProvider.EP_NAME.getExtensionList()) {
            if (!provider.isImplicitUsage(element)) continue;
            return true;
        }
        return false;
    }

    public static boolean isImplicitRead(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        for (ImplicitUsageProvider provider : ImplicitUsageProvider.EP_NAME.getExtensionList()) {
            if (!provider.isImplicitRead(element)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(RefEntity element, @NotNull Collection<? extends RefEntity> entities) {
        if (entities == null) {
            RefUtil.$$$reportNull$$$0(0);
        }
        for (RefEntity refEntity : entities) {
            if (!Comparing.equal(refEntity, element)) continue;
            return true;
        }
        return false;
    }

    public static boolean isImplicitWrite(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        for (ImplicitUsageProvider provider : ImplicitUsageProvider.EP_NAME.getExtensionList()) {
            if (!provider.isImplicitWrite(element)) continue;
            return true;
        }
        return EntryPointsManager.getInstance(element.getProject()).isImplicitWrite(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entities", "com/intellij/codeInspection/reference/RefUtil", "contains"));
    }
}

