/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.rangeSet;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeType;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeUtil;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.MathUtil;
import com.intellij.util.ThreeState;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LongRangeSet {
    LongRangeSet() {
    }

    @NotNull
    public abstract LongRangeSet subtract(@NotNull LongRangeSet var1);

    public LongRangeSet without(long value) {
        return this.subtract(LongRangeSet.point(value));
    }

    public boolean isEmpty() {
        return this == Empty.EMPTY;
    }

    @NotNull
    public abstract LongRangeSet meet(@NotNull LongRangeSet var1);

    @NotNull
    public abstract LongRangeSet join(@NotNull LongRangeSet var1);

    @Nullable
    public abstract LongRangeSet tryJoinExactly(@NotNull LongRangeSet var1);

    public abstract long min();

    public abstract long max();

    @Nullable
    public Long getConstantValue() {
        return null;
    }

    public abstract boolean intersects(LongRangeSet var1);

    public abstract boolean contains(long var1);

    public abstract boolean contains(@NotNull LongRangeSet var1);

    public LongRangeSet fromRelation(@Nullable RelationType relation) {
        if (this.isEmpty() || relation == null) {
            return null;
        }
        return switch (relation) {
            case RelationType.EQ -> this;
            case RelationType.NE -> {
                long min = this.min();
                if (min == this.max()) {
                    yield LongRangeSet.all().without(min);
                }
                yield LongRangeSet.all();
            }
            case RelationType.GT -> {
                long min = this.min();
                if (min == Long.MAX_VALUE) {
                    yield LongRangeSet.empty();
                }
                yield LongRangeSet.range(min + 1L, Long.MAX_VALUE);
            }
            case RelationType.GE -> LongRangeSet.range(this.min(), Long.MAX_VALUE);
            case RelationType.LE -> LongRangeSet.range(Long.MIN_VALUE, this.max());
            case RelationType.LT -> {
                long max = this.max();
                if (max == Long.MIN_VALUE) {
                    yield LongRangeSet.empty();
                }
                yield LongRangeSet.range(Long.MIN_VALUE, max - 1L);
            }
            default -> null;
        };
    }

    @NotNull
    @Nls
    public abstract String getPresentationText(@NotNull LongRangeSet var1);

    @NotNull
    public LongRangeSet mulWiden(LongRangeSet other, LongRangeType lrType) {
        if (Point.ZERO.equals(this)) {
            LongRangeSet longRangeSet = this;
            if (longRangeSet == null) {
                LongRangeSet.$$$reportNull$$$0(0);
            }
            return longRangeSet;
        }
        if (Point.ZERO.equals(other)) {
            LongRangeSet longRangeSet = other;
            if (longRangeSet == null) {
                LongRangeSet.$$$reportNull$$$0(1);
            }
            return longRangeSet;
        }
        if (Point.ONE.equals(this)) {
            LongRangeSet longRangeSet = other;
            if (longRangeSet == null) {
                LongRangeSet.$$$reportNull$$$0(2);
            }
            return longRangeSet;
        }
        if (Point.ONE.equals(other)) {
            LongRangeSet longRangeSet = this;
            if (longRangeSet == null) {
                LongRangeSet.$$$reportNull$$$0(3);
            }
            return longRangeSet;
        }
        if (Point.ZERO.equals(this.mod(LongRangeSet.point(2L))) || Point.ZERO.equals(other.mod(LongRangeSet.point(2L)))) {
            LongRangeSet longRangeSet = LongRangeSet.modRange(lrType.min(), lrType.max(), 2L, 1L);
            if (longRangeSet == null) {
                LongRangeSet.$$$reportNull$$$0(4);
            }
            return longRangeSet;
        }
        LongRangeSet longRangeSet = lrType.fullRange();
        if (longRangeSet == null) {
            LongRangeSet.$$$reportNull$$$0(5);
        }
        return longRangeSet;
    }

    @NotNull
    public LongRangeSet plusWiden(LongRangeSet other, LongRangeType lrType) {
        LongRangeSet val12;
        Point thisPoint;
        LongRangeSet longRangeSet = this;
        if (longRangeSet instanceof Point) {
            thisPoint = (Point)longRangeSet;
            if (other instanceof Point) {
                int mod;
                LongRangeSet constVal;
                int tzb2;
                Point otherPoint = (Point)other;
                long val12 = thisPoint.myValue;
                long val2 = otherPoint.myValue;
                int tzb1 = val12 == 0L ? 0 : Long.numberOfTrailingZeros(val12);
                int n = tzb2 = val2 == 0L ? 0 : Long.numberOfTrailingZeros(val2);
                if (tzb1 > tzb2) {
                    constVal = other;
                    mod = 1 << Math.min(6, tzb1);
                } else {
                    constVal = this;
                    mod = 1 << Math.min(6, tzb2);
                }
                if (mod < 2) {
                    LongRangeSet longRangeSet2 = lrType.fullRange();
                    if (longRangeSet2 == null) {
                        LongRangeSet.$$$reportNull$$$0(6);
                    }
                    return longRangeSet2;
                }
                LongRangeSet longRangeSet3 = LongRangeSet.modRange(lrType.min(), lrType.max(), mod, 1L).plus(constVal, lrType);
                if (longRangeSet3 == null) {
                    LongRangeSet.$$$reportNull$$$0(7);
                }
                return longRangeSet3;
            }
        }
        if ((val12 = this) instanceof Point) {
            thisPoint = (Point)val12;
            if (other instanceof ModRange) {
                int gcd;
                ModRange modRange = (ModRange)other;
                long value = thisPoint.myValue;
                if (value % (long)modRange.myMod == 0L) {
                    LongRangeSet longRangeSet4 = LongRangeSet.modRange(lrType.min(), lrType.max(), modRange.myMod, modRange.myBits);
                    if (longRangeSet4 == null) {
                        LongRangeSet.$$$reportNull$$$0(8);
                    }
                    return longRangeSet4;
                }
                if (modRange.myBits == 1L) {
                    LongRangeSet longRangeSet5 = this.plus(other, lrType);
                    if (longRangeSet5 == null) {
                        LongRangeSet.$$$reportNull$$$0(9);
                    }
                    return longRangeSet5;
                }
                if (value >= -64L && value < 64L && (gcd = LongRangeUtil.gcd(Math.abs((int)value), modRange.myMod)) > 1) {
                    long count2 = modRange.myMod / gcd;
                    long bits = 0L;
                    int i = 0;
                    while ((long)i < count2) {
                        bits |= modRange.myBits >>> i * gcd & (1L << gcd) - 1L;
                        ++i;
                    }
                    LongRangeSet longRangeSet6 = LongRangeSet.modRange(lrType.min(), lrType.max(), gcd, bits);
                    if (longRangeSet6 == null) {
                        LongRangeSet.$$$reportNull$$$0(10);
                    }
                    return longRangeSet6;
                }
            }
        }
        if (other instanceof Point && this instanceof ModRange) {
            LongRangeSet longRangeSet7 = other.plusWiden(this, lrType);
            if (longRangeSet7 == null) {
                LongRangeSet.$$$reportNull$$$0(11);
            }
            return longRangeSet7;
        }
        LongRangeSet longRangeSet8 = lrType.fullRange();
        if (longRangeSet8 == null) {
            LongRangeSet.$$$reportNull$$$0(12);
        }
        return longRangeSet8;
    }

    public abstract boolean isCardinalityBigger(long var1);

    @NotNull
    public abstract LongRangeSet abs(LongRangeType var1);

    @NotNull
    public abstract LongRangeSet negate(LongRangeType var1);

    @NotNull
    public abstract LongRangeSet plus(LongRangeSet var1, LongRangeType var2);

    @NotNull
    public LongRangeSet minus(LongRangeSet other, LongRangeType lrType) {
        LongRangeSet longRangeSet = this.plus(other.negate(lrType), lrType);
        if (longRangeSet == null) {
            LongRangeSet.$$$reportNull$$$0(13);
        }
        return longRangeSet;
    }

    @NotNull
    public LongRangeSet bitwiseOr(LongRangeSet other, LongRangeType lrType) {
        if (this.isEmpty() || other.isEmpty()) {
            LongRangeSet longRangeSet = LongRangeSet.empty();
            if (longRangeSet == null) {
                LongRangeSet.$$$reportNull$$$0(14);
            }
            return longRangeSet;
        }
        LongRangeSet result = LongRangeSet.fromBits(this.getBitwiseMask().or(other.getBitwiseMask()));
        LongRangeSet longRangeSet = result.meet(lrType.fullRange());
        if (longRangeSet == null) {
            LongRangeSet.$$$reportNull$$$0(15);
        }
        return longRangeSet;
    }

    @NotNull
    public LongRangeSet bitwiseXor(LongRangeSet other, LongRangeType lrType) {
        if (this.isEmpty() || other.isEmpty()) {
            LongRangeSet longRangeSet = LongRangeSet.empty();
            if (longRangeSet == null) {
                LongRangeSet.$$$reportNull$$$0(16);
            }
            return longRangeSet;
        }
        LongRangeSet result = LongRangeSet.fromBits(this.getBitwiseMask().xor(other.getBitwiseMask()));
        LongRangeSet longRangeSet = result.meet(lrType.fullRange());
        if (longRangeSet == null) {
            LongRangeSet.$$$reportNull$$$0(17);
        }
        return longRangeSet;
    }

    @NotNull
    public LongRangeSet bitwiseAnd(LongRangeSet other) {
        if (this.isEmpty() || other.isEmpty()) {
            LongRangeSet longRangeSet = LongRangeSet.empty();
            if (longRangeSet == null) {
                LongRangeSet.$$$reportNull$$$0(18);
            }
            return longRangeSet;
        }
        long[] left = LongRangeSet.splitAtZero(this.asRangeArray());
        long[] right = LongRangeSet.splitAtZero(other.asRangeArray());
        if (left.length > 6) {
            left = LongRangeSet.splitAtZero(new long[]{left[0], left[left.length - 1]});
        }
        if (right.length > 6) {
            right = LongRangeSet.splitAtZero(new long[]{right[0], right[right.length - 1]});
        }
        LongRangeUtil.BitString globalMask = this.getBitwiseMask().and(other.getBitwiseMask());
        globalMask = new LongRangeUtil.BitString(globalMask.myBits | globalMask.myMask ^ 0xFFFFFFFFFFFFFFFFL, -1L);
        LongRangeSet result = LongRangeSet.empty();
        for (int i = 0; i < left.length; i += 2) {
            for (int j = 0; j < right.length; j += 2) {
                result = result.join(LongRangeSet.bitwiseAnd(left[i], left[i + 1], right[j], right[j + 1], globalMask));
            }
        }
        LongRangeSet longRangeSet = result;
        if (longRangeSet == null) {
            LongRangeSet.$$$reportNull$$$0(19);
        }
        return longRangeSet;
    }

    public LongRangeSet mul(LongRangeSet multiplier, LongRangeType lrType) {
        if (multiplier.isEmpty()) {
            return multiplier;
        }
        if (multiplier instanceof Point) {
            return multiplier.mul(this, lrType);
        }
        LongRangeUtil.BitString thisMask = this.getBitwiseMask();
        LongRangeUtil.BitString thatMask = multiplier.getBitwiseMask();
        int numZeros = Math.min(6, Math.min(Long.numberOfTrailingZeros(thisMask.myBits), Long.numberOfTrailingZeros(thisMask.myMask ^ 0xFFFFFFFFFFFFFFFFL)) + Math.min(Long.numberOfTrailingZeros(thatMask.myBits), Long.numberOfTrailingZeros(thatMask.myMask ^ 0xFFFFFFFFFFFFFFFFL)));
        return LongRangeSet.modRange(lrType.min(), lrType.max(), 1L << numZeros, 1L);
    }

    LongRangeUtil.BitString getBitwiseMask() {
        if (this.isEmpty()) {
            return LongRangeUtil.BitString.UNSURE;
        }
        return LongRangeUtil.BitString.fromRange(this.min(), this.max());
    }

    @NotNull
    public LongRangeSet div(LongRangeSet divisor, LongRangeType lrType) {
        if (divisor.isEmpty() || divisor.equals(Point.ZERO)) {
            LongRangeSet longRangeSet = LongRangeSet.empty();
            if (longRangeSet == null) {
                LongRangeSet.$$$reportNull$$$0(20);
            }
            return longRangeSet;
        }
        divisor = divisor.meet(lrType.fullRange());
        LongRangeSet dividend = this.meet(lrType.fullRange());
        long[] left = LongRangeSet.splitAtZero(dividend.asRangeArray());
        long[] right = LongRangeSet.splitAtZero(new long[]{divisor.min(), divisor.max()});
        LongRangeSet result = LongRangeSet.empty();
        for (int i = 0; i < left.length; i += 2) {
            for (int j = 0; j < right.length; j += 2) {
                result = result.join(LongRangeSet.divide(left[i], left[i + 1], right[j], right[j + 1], lrType));
            }
        }
        LongRangeSet longRangeSet = result;
        if (longRangeSet == null) {
            LongRangeSet.$$$reportNull$$$0(21);
        }
        return longRangeSet;
    }

    public boolean additionMayOverflow(@NotNull LongRangeSet other, LongRangeType lrType) {
        if (other == null) {
            LongRangeSet.$$$reportNull$$$0(22);
        }
        long leftMin = this.min();
        long leftMax = this.max();
        long rightMin = other.min();
        long rightMax = other.max();
        return lrType.additionMayOverflow(leftMin, rightMin) || lrType.additionMayOverflow(leftMax, rightMax);
    }

    public boolean subtractionMayOverflow(@NotNull LongRangeSet other, LongRangeType lrType) {
        if (other == null) {
            LongRangeSet.$$$reportNull$$$0(23);
        }
        long leftMin = this.min();
        long leftMax = this.max();
        long rightMin = other.min();
        long rightMax = other.max();
        return lrType.subtractionMayOverflow(leftMin, rightMax) || lrType.subtractionMayOverflow(leftMax, rightMin);
    }

    @NotNull
    private static LongRangeSet divide(long dividendMin, long dividendMax, long divisorMin, long divisorMax, LongRangeType lrType) {
        if (divisorMin == 0L) {
            if (divisorMax == 0L) {
                LongRangeSet longRangeSet = LongRangeSet.empty();
                if (longRangeSet == null) {
                    LongRangeSet.$$$reportNull$$$0(24);
                }
                return longRangeSet;
            }
            divisorMin = 1L;
        }
        if (dividendMin >= 0L) {
            LongRangeSet longRangeSet = divisorMin > 0L ? LongRangeSet.range(dividendMin / divisorMax, dividendMax / divisorMin) : LongRangeSet.range(dividendMax / divisorMax, dividendMin / divisorMin);
            if (longRangeSet == null) {
                LongRangeSet.$$$reportNull$$$0(25);
            }
            return longRangeSet;
        }
        if (divisorMin > 0L) {
            LongRangeSet longRangeSet = LongRangeSet.range(dividendMin / divisorMin, dividendMax / divisorMax);
            if (longRangeSet == null) {
                LongRangeSet.$$$reportNull$$$0(26);
            }
            return longRangeSet;
        }
        long minValue = lrType.min();
        if (dividendMin == minValue && divisorMax == -1L) {
            LongRangeSet longRangeSet = LongRangeSet.point(minValue).join(divisorMin == -1L ? LongRangeSet.empty() : LongRangeSet.range(dividendMin / divisorMin, dividendMin / (divisorMax - 1L))).join(dividendMax == minValue ? LongRangeSet.empty() : LongRangeSet.range(dividendMax / divisorMin, (dividendMin + 1L) / divisorMax));
            if (longRangeSet == null) {
                LongRangeSet.$$$reportNull$$$0(27);
            }
            return longRangeSet;
        }
        LongRangeSet longRangeSet = LongRangeSet.range(dividendMax / divisorMin, dividendMin / divisorMax);
        if (longRangeSet == null) {
            LongRangeSet.$$$reportNull$$$0(28);
        }
        return longRangeSet;
    }

    @NotNull
    public LongRangeSet shiftLeft(LongRangeSet shiftSize, LongRangeType lrType) {
        if (this.isEmpty() || shiftSize.isEmpty()) {
            LongRangeSet longRangeSet = LongRangeSet.empty();
            if (longRangeSet == null) {
                LongRangeSet.$$$reportNull$$$0(29);
            }
            return longRangeSet;
        }
        if (shiftSize instanceof Point) {
            Point point = (Point)shiftSize;
            long shift = point.myValue & (long)(lrType.bits() - 1);
            LongRangeSet longRangeSet = LongRangeSet.point(1L << (int)shift).mul(this, lrType);
            if (longRangeSet == null) {
                LongRangeSet.$$$reportNull$$$0(30);
            }
            return longRangeSet;
        }
        LongRangeSet longRangeSet = lrType.fullRange();
        if (longRangeSet == null) {
            LongRangeSet.$$$reportNull$$$0(31);
        }
        return longRangeSet;
    }

    @NotNull
    public LongRangeSet shiftRight(LongRangeSet shiftSize, LongRangeType lrType) {
        LongRangeSet longRangeSet = this.doShiftRight(shiftSize, lrType, false);
        if (longRangeSet == null) {
            LongRangeSet.$$$reportNull$$$0(32);
        }
        return longRangeSet;
    }

    @NotNull
    public LongRangeSet unsignedShiftRight(LongRangeSet shiftSize, LongRangeType lrType) {
        LongRangeSet longRangeSet = this.doShiftRight(shiftSize, lrType, true);
        if (longRangeSet == null) {
            LongRangeSet.$$$reportNull$$$0(33);
        }
        return longRangeSet;
    }

    private LongRangeSet doShiftRight(LongRangeSet shiftSize, LongRangeType lrType, boolean unsigned) {
        LongRangeSet negativeResult;
        if (this.isEmpty() || shiftSize.isEmpty()) {
            return LongRangeSet.empty();
        }
        int maxShift = lrType.bits() - 1;
        if (shiftSize.min() < 0L || shiftSize.max() > (long)maxShift) {
            shiftSize = shiftSize.bitwiseAnd(LongRangeSet.point(maxShift));
        }
        long min = shiftSize.min();
        long max = shiftSize.max();
        LongRangeSet negative = this.meet(LongRangeSet.range(lrType.min(), -1L));
        LongRangeSet positive = this.meet(LongRangeSet.range(0L, lrType.max()));
        LongRangeSet positiveResult = positive.shrPositive(min, max, lrType);
        LongRangeSet negativeComplement = LongRangeSet.point(-1L).minus(negative, lrType);
        if (unsigned) {
            if (min == 0L) {
                positiveResult = positiveResult.join(negative);
                if (max == 0L) {
                    return positiveResult;
                }
                ++min;
            }
            negativeResult = LongRangeSet.point(lrType.max()).minus(negativeComplement.shrPositive(1L, 1L, lrType), lrType).shrPositive(min - 1L, max - 1L, lrType);
        } else {
            negativeResult = LongRangeSet.point(-1L).minus(negativeComplement.shrPositive(min, max, lrType), lrType);
        }
        return positiveResult.join(negativeResult);
    }

    private LongRangeSet shrPositive(long min, long max, LongRangeType lrType) {
        if (this.isEmpty()) {
            return LongRangeSet.empty();
        }
        int maxShift = lrType.bits() - 1;
        if (max == (long)maxShift) {
            return min == max ? Point.ZERO : Point.ZERO.join(this.div(LongRangeSet.range(1L << (int)min, 1L << (int)(max - 1L)), lrType));
        }
        return this.div(LongRangeSet.range(1L << (int)min, 1L << (int)max), lrType);
    }

    @NotNull
    public abstract LongRangeSet mod(LongRangeSet var1);

    private static long[] splitAtZero(long[] ranges) {
        for (int i = 0; i < ranges.length; i += 2) {
            if (ranges[i] >= 0L || ranges[i + 1] < 0L) continue;
            long[] result = new long[ranges.length + 2];
            System.arraycopy(ranges, 0, result, 0, i + 1);
            result[i + 1] = -1L;
            System.arraycopy(ranges, i + 1, result, i + 3, ranges.length - i - 1);
            return result;
        }
        return ranges;
    }

    private static LongRangeSet bitwiseAnd(long leftFrom, long leftTo, long rightFrom, long rightTo, LongRangeUtil.BitString globalMask) {
        LongRangeUtil.BitString leftBits = LongRangeUtil.BitString.fromRange(leftFrom, leftTo);
        LongRangeUtil.BitString rightBits = LongRangeUtil.BitString.fromRange(rightFrom, rightTo);
        LongRangeSet fromBits = LongRangeSet.fromBits(leftBits.and(rightBits).and(globalMask));
        if (leftFrom == leftTo && rightFrom == rightTo) {
            return LongRangeSet.point(leftFrom & rightFrom & (globalMask.myBits | globalMask.myMask ^ 0xFFFFFFFFFFFFFFFFL)).meet(fromBits);
        }
        if (leftFrom == leftTo && Long.bitCount(leftFrom + 1L) == 1) {
            return LongRangeSet.bitwiseMask(rightFrom, rightTo, leftFrom).meet(fromBits);
        }
        if (rightFrom == rightTo && Long.bitCount(rightFrom + 1L) == 1) {
            return LongRangeSet.bitwiseMask(leftFrom, leftTo, rightFrom).meet(fromBits);
        }
        return fromBits;
    }

    private static LongRangeSet bitwiseMask(long from, long to, long mask) {
        if (to - from > mask) {
            return LongRangeSet.range(0L, mask);
        }
        long min = from & mask;
        long max = to & mask;
        assert (min != max);
        if (min < max) {
            return LongRangeSet.range(min, max);
        }
        return new RangeSet(new long[]{0L, max, min, mask});
    }

    private static LongRangeSet fromBits(LongRangeUtil.BitString bits) {
        int j;
        int i;
        if (bits.myMask == -1L) {
            return LongRangeSet.point(bits.myBits);
        }
        long from = 0L;
        for (i = 63; i >= 0 && bits.get(i) != ThreeState.UNSURE; --i) {
            if (bits.get(i) != ThreeState.YES) continue;
            from = LongRangeUtil.setBit(from, i);
        }
        long to = (i == 63 ? 0L : 1L << i + 1) - 1L | from;
        for (j = 0; j < i && bits.get(j) != ThreeState.UNSURE; ++j) {
            if (bits.get(j) != ThreeState.NO) continue;
            to = LongRangeUtil.clearBit(to, j);
        }
        if (i == j) {
            return LongRangeSet.point(bits.myBits & bits.myMask).join(LongRangeSet.point(bits.myBits | bits.myMask ^ 0xFFFFFFFFFFFFFFFFL));
        }
        long modBits = -1L;
        block2: for (int rem = 0; rem < 64; ++rem) {
            for (int pos = 0; pos < 6; ++pos) {
                ThreeState bit = bits.get(pos);
                if (bit != ThreeState.fromBoolean(!LongRangeUtil.isSet(rem, pos))) continue;
                modBits = LongRangeUtil.clearBit(modBits, rem);
                continue block2;
            }
        }
        if (from >= 0L && to < 0L) {
            from = Long.MIN_VALUE;
            to = Long.MAX_VALUE;
        }
        return from < to ? LongRangeSet.modRange(from, to, 64L, modBits) : LongRangeSet.modRange(to, from, 64L, modBits);
    }

    @NlsSafe
    private static String formatNumber(long value) {
        if (value == Long.MAX_VALUE) {
            return "Long.MAX_VALUE";
        }
        if (value == 0x7FFFFFFFFFFFFFFEL) {
            return "Long.MAX_VALUE-1";
        }
        if (value == Long.MIN_VALUE) {
            return "Long.MIN_VALUE";
        }
        if (value == -9223372036854775807L) {
            return "Long.MIN_VALUE+1";
        }
        if (value == Integer.MAX_VALUE) {
            return "Integer.MAX_VALUE";
        }
        if (value == 0x7FFFFFFEL) {
            return "Integer.MAX_VALUE-1";
        }
        if (value == Integer.MIN_VALUE) {
            return "Integer.MIN_VALUE";
        }
        if (value == -2147483647L) {
            return "Integer.MIN_VALUE+1";
        }
        return String.valueOf(value);
    }

    public abstract LongStream stream();

    public static LongRangeSet empty() {
        return Empty.EMPTY;
    }

    @NotNull
    public static LongRangeSet all() {
        Range range = Range.LONG_RANGE;
        if (range == null) {
            LongRangeSet.$$$reportNull$$$0(34);
        }
        return range;
    }

    public static LongRangeSet point(long value) {
        return value == 0L ? Point.ZERO : (value == 1L ? Point.ONE : new Point(value));
    }

    @Nullable
    public static LongRangeSet fromConstant(Object val) {
        if (val instanceof Byte || val instanceof Short || val instanceof Integer || val instanceof Long) {
            return LongRangeSet.point(((Number)val).longValue());
        }
        if (val instanceof Character) {
            Character character = (Character)val;
            return LongRangeSet.point(character.charValue());
        }
        return null;
    }

    public static LongRangeSet range(long from, long to) {
        return from == to ? LongRangeSet.point(from) : new Range(from, to);
    }

    public static LongRangeSet modRange(long from, long to, long mod, long bits) {
        long leftHalf;
        int halfMod;
        long rightHalf;
        int toBit;
        long rotatedTo;
        long rotatedFrom;
        if (mod <= 0L) {
            throw new IllegalArgumentException();
        }
        if (bits == 0L) {
            return LongRangeSet.empty();
        }
        if (mod == 1L || mod > 64L) {
            return LongRangeSet.range(from, to);
        }
        int intMod = (int)mod;
        if ((from += (long)Long.numberOfTrailingZeros(rotatedFrom = LongRangeUtil.rotateRemainders(bits, intMod, LongRangeUtil.remainder(from, intMod)))) > (to -= (long)(intMod - (64 - Long.numberOfLeadingZeros(rotatedTo = LongRangeUtil.rotateRemainders(bits, intMod, toBit = (LongRangeUtil.remainder(to, intMod) + 1) % intMod)))))) {
            return LongRangeSet.empty();
        }
        if (from == to) {
            return new Point(from);
        }
        long length = to - from;
        if (length > 0L && length <= (long)(intMod / 2)) {
            for (int newMod = (int)length; newMod <= intMod / 2; ++newMod) {
                if (intMod % newMod != 0) continue;
                long newBits = 0L;
                for (long i = from; i >= from && i <= to; ++i) {
                    if (!LongRangeUtil.isSet(bits, LongRangeUtil.remainder(i, intMod))) continue;
                    newBits = LongRangeUtil.setBit(newBits, LongRangeUtil.remainder(i, newMod));
                }
                intMod = newMod;
                bits = newBits;
                if (bits != 0L) break;
                return LongRangeSet.empty();
            }
        }
        if (intMod % 2 == 0 && (rightHalf = LongRangeUtil.extractBits(bits, 0, halfMod = intMod / 2)) == (leftHalf = LongRangeUtil.extractBits(bits, halfMod, halfMod))) {
            return LongRangeSet.modRange(from, to, halfMod, leftHalf);
        }
        if (Long.bitCount(bits) == intMod) {
            return LongRangeSet.range(from, to);
        }
        ModRange range = new ModRange(from, to, intMod, bits);
        LongRangeSet fullRange = LongRangeSet.range(from, to);
        return range.contains(fullRange) ? fullRange : range;
    }

    @NotNull
    public abstract List<LongRangeSet> asRanges();

    abstract long[] asRangeArray();

    static String toString(long from, long to) {
        return LongRangeSet.formatNumber(from) + (String)(from == to ? "" : (to - from == 1L ? ", " : "..") + LongRangeSet.formatNumber(to));
    }

    static LongRangeSet fromRanges(long[] ranges, int bound) {
        if (bound == 0) {
            return Empty.EMPTY;
        }
        if (bound == 2) {
            return LongRangeSet.range(ranges[0], ranges[1]);
        }
        return new RangeSet(Arrays.copyOf(ranges, bound));
    }

    public static LongRangeSet fromRemainder(long mod, LongRangeSet remainders) {
        long max;
        if (remainders.isEmpty()) {
            return LongRangeSet.empty();
        }
        long min = remainders.min() > 0L ? 1L : Long.MIN_VALUE;
        long l = max = remainders.max() < 0L ? -1L : Long.MAX_VALUE;
        if (mod > 1L && mod <= 64L) {
            long bits = remainders.contains(0L) ? 1L : 0L;
            int rem = 1;
            while ((long)rem < mod) {
                if (remainders.contains(rem) || remainders.contains((long)rem - mod)) {
                    bits = LongRangeUtil.setBit(bits, rem);
                }
                ++rem;
            }
            return LongRangeSet.modRange(min, max, mod, bits);
        }
        return LongRangeSet.range(min, max);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 22, 23 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeSet";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "mulWiden";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "plusWiden";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "minus";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "bitwiseOr";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "bitwiseXor";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "bitwiseAnd";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "div";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeSet";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "divide";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "shiftLeft";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "shiftRight";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "unsignedShiftRight";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "all";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "additionMayOverflow";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "subtractionMayOverflow";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 22, 23 -> new IllegalArgumentException(string);
        };
    }

    static final class Empty
    extends LongRangeSet {
        static final LongRangeSet EMPTY = new Empty();

        Empty() {
        }

        @Override
        @NotNull
        public LongRangeSet subtract(@NotNull LongRangeSet other) {
            if (other == null) {
                Empty.$$$reportNull$$$0(0);
            }
            Empty empty = this;
            if (empty == null) {
                Empty.$$$reportNull$$$0(1);
            }
            return empty;
        }

        @Override
        @NotNull
        public LongRangeSet meet(@NotNull LongRangeSet other) {
            if (other == null) {
                Empty.$$$reportNull$$$0(2);
            }
            Empty empty = this;
            if (empty == null) {
                Empty.$$$reportNull$$$0(3);
            }
            return empty;
        }

        @Override
        @NotNull
        public LongRangeSet join(@NotNull LongRangeSet other) {
            if (other == null) {
                Empty.$$$reportNull$$$0(4);
            }
            LongRangeSet longRangeSet = other;
            if (longRangeSet == null) {
                Empty.$$$reportNull$$$0(5);
            }
            return longRangeSet;
        }

        @Override
        @NotNull
        public LongRangeSet tryJoinExactly(@NotNull LongRangeSet other) {
            if (other == null) {
                Empty.$$$reportNull$$$0(6);
            }
            LongRangeSet longRangeSet = other;
            if (longRangeSet == null) {
                Empty.$$$reportNull$$$0(7);
            }
            return longRangeSet;
        }

        @Override
        public long min() {
            throw new NoSuchElementException();
        }

        @Override
        public long max() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean intersects(LongRangeSet other) {
            return false;
        }

        @Override
        public boolean contains(long value) {
            return false;
        }

        @Override
        public boolean contains(@NotNull LongRangeSet other) {
            if (other == null) {
                Empty.$$$reportNull$$$0(8);
            }
            return other.isEmpty();
        }

        @Override
        @NotNull
        public String getPresentationText(@NotNull LongRangeSet fullTypeRange) {
            if (fullTypeRange == null) {
                Empty.$$$reportNull$$$0(9);
            }
            String string = InspectionsBundle.message("long.range.set.presentation.empty", new Object[0]);
            if (string == null) {
                Empty.$$$reportNull$$$0(10);
            }
            return string;
        }

        @Override
        public boolean isCardinalityBigger(long cutoff) {
            return cutoff < 0L;
        }

        @Override
        @NotNull
        public LongRangeSet abs(LongRangeType lrType) {
            Empty empty = this;
            if (empty == null) {
                Empty.$$$reportNull$$$0(11);
            }
            return empty;
        }

        @Override
        @NotNull
        public LongRangeSet negate(LongRangeType lrType) {
            Empty empty = this;
            if (empty == null) {
                Empty.$$$reportNull$$$0(12);
            }
            return empty;
        }

        @Override
        @NotNull
        public LongRangeSet plus(LongRangeSet other, LongRangeType lrType) {
            Empty empty = this;
            if (empty == null) {
                Empty.$$$reportNull$$$0(13);
            }
            return empty;
        }

        @Override
        public LongRangeSet mul(LongRangeSet multiplier, LongRangeType lrType) {
            return this;
        }

        @Override
        @NotNull
        public LongRangeSet mod(LongRangeSet divisor) {
            LongRangeSet longRangeSet = Empty.empty();
            if (longRangeSet == null) {
                Empty.$$$reportNull$$$0(14);
            }
            return longRangeSet;
        }

        @Override
        public LongStream stream() {
            return LongStream.empty();
        }

        @Override
        @NotNull
        public List<LongRangeSet> asRanges() {
            List<LongRangeSet> list = Collections.emptyList();
            if (list == null) {
                Empty.$$$reportNull$$$0(15);
            }
            return list;
        }

        @Override
        long[] asRangeArray() {
            return new long[0];
        }

        public int hashCode() {
            return 2154231;
        }

        public String toString() {
            return "{}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3, 5, 7, 10, 11, 12, 13, 14, 15 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeSet$Empty";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fullTypeRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeSet$Empty";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "subtract";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "meet";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "join";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "tryJoinExactly";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentationText";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "abs";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "negate";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "plus";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "mod";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asRanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "subtract";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "meet";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "join";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "tryJoinExactly";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentationText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3, 5, 7, 10, 11, 12, 13, 14, 15 -> new IllegalStateException(string);
            };
        }
    }

    static final class Point
    extends LongRangeSet {
        static final Point ZERO = new Point(0L);
        static final Point ONE = new Point(1L);
        final long myValue;

        Point(long value) {
            this.myValue = value;
        }

        @Override
        @NotNull
        public String getPresentationText(@NotNull LongRangeSet fullTypeRange) {
            if (fullTypeRange == null) {
                Point.$$$reportNull$$$0(0);
            }
            String string = LongRangeSet.formatNumber(this.myValue);
            if (string == null) {
                Point.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public boolean isCardinalityBigger(long cutoff) {
            return cutoff < 1L;
        }

        @Override
        @NotNull
        public LongRangeSet subtract(@NotNull LongRangeSet other) {
            if (other == null) {
                Point.$$$reportNull$$$0(2);
            }
            LongRangeSet longRangeSet = other.contains(this.myValue) ? Empty.EMPTY : this;
            if (longRangeSet == null) {
                Point.$$$reportNull$$$0(3);
            }
            return longRangeSet;
        }

        @Override
        @NotNull
        public LongRangeSet meet(@NotNull LongRangeSet other) {
            if (other == null) {
                Point.$$$reportNull$$$0(4);
            }
            LongRangeSet longRangeSet = other.contains(this.myValue) ? this : Empty.EMPTY;
            if (longRangeSet == null) {
                Point.$$$reportNull$$$0(5);
            }
            return longRangeSet;
        }

        @Override
        public long min() {
            return this.myValue;
        }

        @Override
        public long max() {
            return this.myValue;
        }

        @Override
        public Long getConstantValue() {
            return this.myValue;
        }

        @Override
        @NotNull
        public LongRangeSet join(@NotNull LongRangeSet other) {
            long[] result;
            boolean touchRight;
            if (other == null) {
                Point.$$$reportNull$$$0(6);
            }
            if (other.isEmpty() || other == this) {
                Point point = this;
                if (point == null) {
                    Point.$$$reportNull$$$0(7);
                }
                return point;
            }
            if (other.contains(this.myValue)) {
                LongRangeSet longRangeSet = other;
                if (longRangeSet == null) {
                    Point.$$$reportNull$$$0(8);
                }
                return longRangeSet;
            }
            if (other instanceof Point) {
                long value2;
                Point point = (Point)other;
                long value1 = Math.min(this.myValue, point.myValue);
                return value1 + 1L == (value2 = Math.max(this.myValue, point.myValue)) ? Point.range(value1, value2) : new RangeSet(new long[]{value1, value1, value2, value2});
            }
            if (other instanceof ModRange) {
                LongRangeSet longRangeSet = other.join(this);
                if (longRangeSet == null) {
                    Point.$$$reportNull$$$0(9);
                }
                return longRangeSet;
            }
            if (other instanceof Range) {
                if (this.myValue < other.min()) {
                    return this.myValue + 1L == other.min() ? Point.range(this.myValue, other.max()) : new RangeSet(new long[]{this.myValue, this.myValue, other.min(), other.max()});
                }
                assert (this.myValue > other.max());
                return this.myValue - 1L == other.max() ? Point.range(other.min(), this.myValue) : new RangeSet(new long[]{other.min(), other.max(), this.myValue, this.myValue});
            }
            long[] longs = other.asRangeArray();
            int pos = -Arrays.binarySearch(longs, this.myValue) - 1;
            assert (pos >= 0 && pos % 2 == 0);
            boolean touchLeft = pos > 0 && longs[pos - 1] + 1L == this.myValue;
            boolean bl = touchRight = pos < longs.length - 1 && this.myValue + 1L == longs[pos];
            if (touchLeft) {
                if (touchRight) {
                    result = new long[longs.length - 2];
                    System.arraycopy(longs, 0, result, 0, pos - 1);
                    System.arraycopy(longs, pos + 1, result, pos - 1, longs.length - pos - 1);
                } else {
                    result = (long[])longs.clone();
                    result[pos - 1] = this.myValue;
                }
            } else if (touchRight) {
                result = (long[])longs.clone();
                result[pos] = this.myValue;
            } else {
                result = new long[longs.length + 2];
                System.arraycopy(longs, 0, result, 0, pos);
                long l = this.myValue;
                result[pos + 1] = l;
                result[pos] = l;
                System.arraycopy(longs, pos, result, pos + 2, longs.length - pos);
            }
            LongRangeSet longRangeSet = Point.fromRanges(result, result.length);
            if (longRangeSet == null) {
                Point.$$$reportNull$$$0(10);
            }
            return longRangeSet;
        }

        @Override
        @Nullable
        public LongRangeSet tryJoinExactly(@NotNull LongRangeSet other) {
            if (other == null) {
                Point.$$$reportNull$$$0(11);
            }
            if (other instanceof ModRange) {
                return other.tryJoinExactly(this);
            }
            return this.join(other);
        }

        @Override
        public boolean intersects(LongRangeSet other) {
            return other.contains(this.myValue);
        }

        @Override
        public boolean contains(long value) {
            return this.myValue == value;
        }

        @Override
        public boolean contains(@NotNull LongRangeSet other) {
            if (other == null) {
                Point.$$$reportNull$$$0(12);
            }
            return other.isEmpty() || this.equals(other);
        }

        @Override
        @NotNull
        public LongRangeSet abs(LongRangeType lrType) {
            LongRangeSet longRangeSet = this.myValue >= 0L || this.myValue == lrType.min() ? this : Point.point(-this.myValue);
            if (longRangeSet == null) {
                Point.$$$reportNull$$$0(13);
            }
            return longRangeSet;
        }

        @Override
        @NotNull
        public LongRangeSet negate(LongRangeType lrType) {
            LongRangeSet longRangeSet = this.myValue == lrType.min() ? this : Point.point(-this.myValue);
            if (longRangeSet == null) {
                Point.$$$reportNull$$$0(14);
            }
            return longRangeSet;
        }

        @Override
        @NotNull
        public LongRangeSet plus(LongRangeSet other, LongRangeType lrType) {
            if (other.isEmpty()) {
                LongRangeSet longRangeSet = other;
                if (longRangeSet == null) {
                    Point.$$$reportNull$$$0(15);
                }
                return longRangeSet;
            }
            if (other instanceof Point) {
                Point point = (Point)other;
                long res = this.myValue + point.myValue;
                LongRangeSet longRangeSet = Point.point(lrType.cast(res));
                if (longRangeSet == null) {
                    Point.$$$reportNull$$$0(16);
                }
                return longRangeSet;
            }
            LongRangeSet longRangeSet = other.plus(this, lrType);
            if (longRangeSet == null) {
                Point.$$$reportNull$$$0(17);
            }
            return longRangeSet;
        }

        @Override
        public LongRangeSet mul(LongRangeSet multiplier, LongRangeType lrType) {
            if (multiplier.isEmpty()) {
                return multiplier;
            }
            if (this.myValue == 0L) {
                return this;
            }
            if (this.myValue == 1L) {
                return multiplier;
            }
            if (this.myValue == -1L) {
                return multiplier.negate(lrType);
            }
            if (multiplier instanceof Point) {
                Point point = (Point)multiplier;
                long val = point.myValue;
                long res = this.myValue * val;
                return Point.point(lrType.cast(res));
            }
            boolean overflow = false;
            long min = multiplier.min();
            long max = multiplier.max();
            if (lrType == LongRangeType.INT64) {
                try {
                    min = Math.multiplyExact(min, this.myValue);
                    max = Math.multiplyExact(max, this.myValue);
                }
                catch (ArithmeticException e) {
                    overflow = true;
                }
            } else {
                assert (lrType.bytes() <= 4);
                if ((min *= this.myValue) != lrType.cast(min) || (max *= this.myValue) != lrType.cast(max)) {
                    overflow = true;
                }
            }
            LongRangeSet result = overflow ? lrType.fullRange() : (min > max ? Point.range(max, min) : Point.range(min, max));
            long abs = Math.abs(this.myValue);
            if (overflow) {
                abs = Long.lowestOneBit(abs);
            }
            if (abs < 0L || abs > 64L && Long.bitCount(abs) == 1) {
                abs = 64L;
            }
            if (multiplier instanceof ModRange) {
                ModRange modRange = (ModRange)multiplier;
                if (modRange.myBits == 1L && abs < 64L) {
                    int mod = modRange.myMod;
                    if ((abs *= overflow ? Long.lowestOneBit(mod) : (long)mod) < 0L || abs > 64L && Long.bitCount(abs) == 1) {
                        abs = 64L;
                    }
                }
            }
            return Point.modRange(result.min(), result.max(), abs, 1L);
        }

        @Override
        @NotNull
        public LongRangeSet mod(LongRangeSet divisor) {
            long abs;
            if (divisor.isEmpty() || divisor.equals(ZERO)) {
                LongRangeSet longRangeSet = Point.empty();
                if (longRangeSet == null) {
                    Point.$$$reportNull$$$0(18);
                }
                return longRangeSet;
            }
            if (this.myValue == 0L) {
                Point point = this;
                if (point == null) {
                    Point.$$$reportNull$$$0(19);
                }
                return point;
            }
            if (divisor instanceof Point) {
                Point point = (Point)divisor;
                LongRangeSet longRangeSet = LongRangeSet.point(this.myValue % point.myValue);
                if (longRangeSet == null) {
                    Point.$$$reportNull$$$0(20);
                }
                return longRangeSet;
            }
            if (this.myValue != Long.MIN_VALUE && !divisor.intersects(LongRangeSet.range(-(abs = Math.abs(this.myValue)), abs))) {
                Point point = this;
                if (point == null) {
                    Point.$$$reportNull$$$0(21);
                }
                return point;
            }
            LongRangeSet addend = Point.empty();
            if (divisor.contains(Long.MIN_VALUE)) {
                divisor = divisor.subtract(Point.point(Long.MIN_VALUE));
                addend = Point.point(this.myValue);
            }
            long max = Math.max(0L, Math.max(Math.abs(divisor.min()), Math.abs(divisor.max())) - 1L);
            if (this.myValue < 0L) {
                LongRangeSet longRangeSet = LongRangeSet.range(Math.max(this.myValue, -max), 0L).join(addend);
                if (longRangeSet == null) {
                    Point.$$$reportNull$$$0(22);
                }
                return longRangeSet;
            }
            LongRangeSet longRangeSet = LongRangeSet.range(0L, Math.min(this.myValue, max)).join(addend);
            if (longRangeSet == null) {
                Point.$$$reportNull$$$0(23);
            }
            return longRangeSet;
        }

        @Override
        public LongStream stream() {
            return LongStream.of(this.myValue);
        }

        @Override
        @NotNull
        public List<LongRangeSet> asRanges() {
            List<LongRangeSet> list = Collections.singletonList(this);
            if (list == null) {
                Point.$$$reportNull$$$0(24);
            }
            return list;
        }

        @Override
        long[] asRangeArray() {
            return new long[]{this.myValue, this.myValue};
        }

        public int hashCode() {
            return Long.hashCode(this.myValue);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Point)) return false;
            Point point = (Point)o;
            if (this.myValue != point.myValue) return false;
            return true;
        }

        public String toString() {
            return "{" + LongRangeSet.formatNumber(this.myValue) + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3, 5, 7, 8, 9, 10, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fullTypeRange";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeSet$Point";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeSet$Point";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentationText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "subtract";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "meet";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "join";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "abs";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "negate";
                    break;
                }
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "plus";
                    break;
                }
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "mod";
                    break;
                }
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asRanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentationText";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "subtract";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "meet";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "join";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "tryJoinExactly";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3, 5, 7, 8, 9, 10, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24 -> new IllegalStateException(string);
            };
        }
    }

    static final class ModRange
    extends Range {
        private final int myMod;
        private final long myBits;

        ModRange(long from, long to, int mod, long bits) {
            super(from, to);
            assert (mod > 1 && mod <= 64);
            this.myMod = mod;
            this.myBits = bits;
            assert ((bits & (this.getMask() ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) : "bits outside of mask should be zero";
            assert (bits != this.getMask()) : "at least one bit in mask should be zero, otherwise simple Range could be used";
        }

        @Override
        @NotNull
        public String getPresentationText(@NotNull LongRangeSet fullTypeRange) {
            if (fullTypeRange == null) {
                ModRange.$$$reportNull$$$0(0);
            }
            fullTypeRange = ModRange.modRange(fullTypeRange.min(), fullTypeRange.max(), this.myMod, this.myBits);
            Object prefix = null;
            if (fullTypeRange.min() == this.myFrom) {
                prefix = fullTypeRange.max() == this.myTo ? "" : "<= " + LongRangeSet.formatNumber(this.myTo);
            } else if (fullTypeRange.max() == this.myTo) {
                prefix = ">= " + LongRangeSet.formatNumber(this.myFrom);
            }
            if (prefix != null) {
                if (((String)prefix).isEmpty()) {
                    String string = this.getSuffix();
                    if (string == null) {
                        ModRange.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                String string = InspectionsBundle.message("long.range.set.presentation.range.with.mod", prefix, this.getSuffix());
                if (string == null) {
                    ModRange.$$$reportNull$$$0(2);
                }
                return string;
            }
            String rangeMessage = InspectionsBundle.message("long.range.set.presentation.range", super.toString());
            String string = InspectionsBundle.message("long.range.set.presentation.range.with.mod", rangeMessage, this.getSuffix());
            if (string == null) {
                ModRange.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public boolean isCardinalityBigger(long cutoff) {
            long bottom = this.myFrom - 1L - (long)LongRangeUtil.remainder(this.myFrom - 1L, this.myMod) + (long)this.myMod;
            long top = this.myTo - (long)LongRangeUtil.remainder(this.myTo, this.myMod);
            if (bottom >= this.myFrom && top > bottom && this.myTo >= top) {
                long i;
                int count2 = Long.bitCount(this.myBits);
                long wholeCount = (top / (long)this.myMod - bottom / (long)this.myMod) * (long)count2;
                if (wholeCount < 0L || wholeCount > cutoff) {
                    return true;
                }
                for (i = this.myFrom; i < bottom; ++i) {
                    if (!LongRangeUtil.isSet(this.myBits, LongRangeUtil.remainder(i, this.myMod))) continue;
                    ++wholeCount;
                }
                for (i = top; i <= this.myTo; ++i) {
                    if (!LongRangeUtil.isSet(this.myBits, LongRangeUtil.remainder(i, this.myMod))) continue;
                    ++wholeCount;
                }
                return wholeCount < 0L || wholeCount > cutoff;
            }
            return this.stream().limit(Math.max(0L, cutoff + 1L)).count() > cutoff;
        }

        @Override
        public boolean contains(long value) {
            return super.contains(value) && LongRangeUtil.isSet(this.myBits, LongRangeUtil.remainder(value, this.myMod));
        }

        @Override
        @NotNull
        public LongRangeSet subtract(@NotNull LongRangeSet other) {
            if (other == null) {
                ModRange.$$$reportNull$$$0(4);
            }
            if (other instanceof Point) {
                Point p = (Point)other;
                if (p.myValue == this.myFrom) {
                    LongRangeSet longRangeSet = ModRange.modRange(this.myFrom + 1L, this.myTo, this.myMod, this.myBits);
                    if (longRangeSet == null) {
                        ModRange.$$$reportNull$$$0(5);
                    }
                    return longRangeSet;
                }
                if (p.myValue == this.myTo) {
                    LongRangeSet longRangeSet = ModRange.modRange(this.myFrom, this.myTo - 1L, this.myMod, this.myBits);
                    if (longRangeSet == null) {
                        ModRange.$$$reportNull$$$0(6);
                    }
                    return longRangeSet;
                }
            }
            if (other instanceof Range) {
                Range r = (Range)other;
                if (!(other instanceof ModRange)) {
                    if (r.myFrom <= this.myFrom && r.myTo >= this.myFrom && r.myTo < this.myTo) {
                        LongRangeSet longRangeSet = ModRange.modRange(r.myTo + 1L, this.myTo, this.myMod, this.myBits);
                        if (longRangeSet == null) {
                            ModRange.$$$reportNull$$$0(7);
                        }
                        return longRangeSet;
                    }
                    if (r.myFrom > this.myFrom && r.myFrom <= this.myTo && r.myTo >= this.myTo) {
                        LongRangeSet longRangeSet = ModRange.modRange(this.myFrom, r.myFrom - 1L, this.myMod, this.myBits);
                        if (longRangeSet == null) {
                            ModRange.$$$reportNull$$$0(8);
                        }
                        return longRangeSet;
                    }
                }
            }
            LongRangeSet longRangeSet = super.subtract(other);
            if (longRangeSet == null) {
                ModRange.$$$reportNull$$$0(9);
            }
            return longRangeSet;
        }

        @Override
        @NotNull
        public LongRangeSet meet(@NotNull LongRangeSet other) {
            LongRangeSet intersection;
            if (other == null) {
                ModRange.$$$reportNull$$$0(10);
            }
            if ((intersection = super.meet(other)) instanceof RangeSet) {
                long min = intersection.min();
                long max = intersection.max();
                long diff = max - min;
                if (diff > 0L && diff < 64L) {
                    for (byte newMod = (byte)(diff + 1L); newMod <= 64; newMod = (byte)(newMod + 1)) {
                        if (newMod % this.myMod != 0) continue;
                        long bits = this.widenBits(newMod);
                        for (long pos = min; pos <= max; ++pos) {
                            int bit = LongRangeUtil.remainder(pos, newMod);
                            if (!LongRangeUtil.isSet(bits, bit) || intersection.contains(pos)) continue;
                            bits = LongRangeUtil.clearBit(bits, bit);
                        }
                        LongRangeSet longRangeSet = ModRange.modRange(min, max, newMod, bits);
                        if (longRangeSet == null) {
                            ModRange.$$$reportNull$$$0(11);
                        }
                        return longRangeSet;
                    }
                }
                long[] ranges = ((RangeSet)intersection).myRanges;
                boolean emptyHoles = true;
                for (int i = 2; i < ranges.length; i += 2) {
                    if (!ModRange.range(ranges[i - 1] + 1L, ranges[i] - 1L).intersects(this)) continue;
                    emptyHoles = false;
                    break;
                }
                if (emptyHoles) {
                    intersection = ModRange.range(min, max);
                }
            }
            if (intersection instanceof Range || intersection instanceof Point) {
                long bits = this.myBits;
                int mod = this.myMod;
                if (other instanceof ModRange) {
                    ModRange modRange = (ModRange)other;
                    int lcm = this.lcm(modRange.myMod);
                    if (lcm <= 64) {
                        bits = this.widenBits(lcm) & modRange.widenBits(lcm);
                        mod = (byte)lcm;
                    } else if (modRange.myMod > this.myMod) {
                        bits = modRange.myBits;
                        mod = modRange.myMod;
                    }
                }
                LongRangeSet longRangeSet = ModRange.modRange(intersection.min(), intersection.max(), mod, bits);
                if (longRangeSet == null) {
                    ModRange.$$$reportNull$$$0(12);
                }
                return longRangeSet;
            }
            LongRangeSet longRangeSet = intersection;
            if (longRangeSet == null) {
                ModRange.$$$reportNull$$$0(13);
            }
            return longRangeSet;
        }

        @Override
        public boolean intersects(LongRangeSet other) {
            if (other instanceof Point) {
                Point point = (Point)other;
                return this.contains(point.myValue);
            }
            if (other instanceof ModRange) {
                ModRange modRange = (ModRange)other;
                int lcm = this.lcm(modRange.myMod);
                if (lcm <= 64 && (modRange.widenBits(lcm) & this.widenBits(lcm)) == 0L) {
                    return false;
                }
            }
            long[] otherRanges = other.asRangeArray();
            for (int i = 0; i < otherRanges.length && otherRanges[i] <= this.myTo; i += 2) {
                if (this.myTo < otherRanges[i] || this.myFrom > otherRanges[i + 1] || ModRange.modRange(otherRanges[i], otherRanges[i + 1], this.myMod, this.myBits).isEmpty()) continue;
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public LongRangeSet join(@NotNull LongRangeSet other) {
            if (other == null) {
                ModRange.$$$reportNull$$$0(14);
            }
            if (other instanceof ModRange) {
                ModRange modRange = (ModRange)other;
                int lcm = this.lcm(modRange.myMod);
                if (lcm <= 64) {
                    long bits = this.widenBits(lcm) | modRange.widenBits(lcm);
                    if (this.myTo >= modRange.myFrom && this.myFrom <= modRange.myTo || this.myTo < modRange.myFrom && ModRange.modRange(this.myTo + 1L, modRange.myFrom - 1L, lcm, bits).isEmpty() || modRange.myTo < this.myFrom && ModRange.modRange(modRange.myTo + 1L, this.myFrom - 1L, lcm, bits).isEmpty()) {
                        LongRangeSet longRangeSet = ModRange.modRange(Math.min(this.myFrom, modRange.myFrom), Math.max(this.myTo, modRange.myTo), lcm, bits);
                        if (longRangeSet == null) {
                            ModRange.$$$reportNull$$$0(15);
                        }
                        return longRangeSet;
                    }
                }
            }
            if (other instanceof Point) {
                Point point = (Point)other;
                long val = point.myValue;
                if (LongRangeUtil.isSet(this.myBits, LongRangeUtil.remainder(val, this.myMod))) {
                    if (val >= this.myFrom && val <= this.myTo) {
                        ModRange modRange = this;
                        if (modRange == null) {
                            ModRange.$$$reportNull$$$0(16);
                        }
                        return modRange;
                    }
                    if (val < this.myFrom && ModRange.modRange(val + 1L, this.myFrom - 1L, this.myMod, this.myBits).isEmpty() || val > this.myTo && ModRange.modRange(this.myTo + 1L, val - 1L, this.myMod, this.myBits).isEmpty()) {
                        LongRangeSet longRangeSet = ModRange.modRange(Math.min(this.myFrom, val), Math.max(this.myTo, val), this.myMod, this.myBits);
                        if (longRangeSet == null) {
                            ModRange.$$$reportNull$$$0(17);
                        }
                        return longRangeSet;
                    }
                }
                LongRangeSet longRangeSet = other.join(ModRange.range(this.myFrom, this.myTo));
                if (longRangeSet == null) {
                    ModRange.$$$reportNull$$$0(18);
                }
                return longRangeSet;
            }
            LongRangeSet longRangeSet = super.join(other);
            if (longRangeSet == null) {
                ModRange.$$$reportNull$$$0(19);
            }
            return longRangeSet;
        }

        @Override
        @Nullable
        public LongRangeSet tryJoinExactly(@NotNull LongRangeSet other) {
            if (other == null) {
                ModRange.$$$reportNull$$$0(20);
            }
            if (this.contains(other)) {
                return this;
            }
            if (other.contains(this)) {
                return other;
            }
            return null;
        }

        @Override
        public boolean contains(@NotNull LongRangeSet other) {
            if (other == null) {
                ModRange.$$$reportNull$$$0(21);
            }
            if (other instanceof ModRange) {
                ModRange modRange = (ModRange)other;
                if (modRange.myFrom < this.myFrom || modRange.myTo > this.myTo) {
                    return false;
                }
                int lcm = this.lcm(modRange.myMod);
                if (lcm <= 64) {
                    return ((this.widenBits(lcm) ^ 0xFFFFFFFFFFFFFFFFL) & modRange.widenBits(lcm)) == 0L;
                }
            }
            long[] ranges = other.asRangeArray();
            for (int i = 0; i < ranges.length; i += 2) {
                if (this.contains(ranges[i], ranges[i + 1])) continue;
                return false;
            }
            return true;
        }

        @Override
        @NotNull
        public LongRangeSet negate(LongRangeType lrType) {
            LongRangeSet negated = super.negate(lrType);
            if (negated instanceof Range) {
                long reverse = Long.reverse(this.myBits & 0xFFFFFFFFFFFFFFFEL);
                long negatedBits = (this.myMod == 64 ? reverse << 1 : reverse >>> 64 - this.myMod - 1) | this.myBits & 1L;
                LongRangeSet longRangeSet = ModRange.modRange(negated.min(), negated.max(), this.myMod, negatedBits);
                if (longRangeSet == null) {
                    ModRange.$$$reportNull$$$0(22);
                }
                return longRangeSet;
            }
            LongRangeSet longRangeSet = negated;
            if (longRangeSet == null) {
                ModRange.$$$reportNull$$$0(23);
            }
            return longRangeSet;
        }

        @Override
        @NotNull
        public LongRangeSet plus(LongRangeSet other, LongRangeType lrType) {
            LongRangeSet set;
            block9: {
                int n;
                block8: {
                    set = super.plus(other, lrType);
                    if (other instanceof Point) break block8;
                    if (!(other instanceof ModRange)) break block9;
                    ModRange modRange = (ModRange)other;
                    if (modRange.myMod != this.myMod || Long.bitCount(modRange.myBits) != 1) break block9;
                }
                long[] ranges = set.asRangeArray();
                LongRangeSet result = ModRange.empty();
                if (other instanceof Point) {
                    Point point = (Point)other;
                    n = LongRangeUtil.remainder(point.myValue, this.myMod);
                } else {
                    n = Long.numberOfTrailingZeros(((ModRange)other).myBits);
                }
                int bit = n;
                long bits = LongRangeUtil.rotateRemainders(this.myBits, this.myMod, this.myMod - bit);
                for (int i = 0; i < ranges.length; i += 2) {
                    LongRangeSet plus = Integer.bitCount(this.myMod) == 1 || !this.additionMayOverflow(other, lrType) ? ModRange.modRange(ranges[i], ranges[i + 1], this.myMod, bits) : ModRange.range(ranges[i], ranges[i + 1]);
                    result = result.join(plus);
                }
                LongRangeSet longRangeSet = result;
                if (longRangeSet == null) {
                    ModRange.$$$reportNull$$$0(24);
                }
                return longRangeSet;
            }
            LongRangeSet longRangeSet = set;
            if (longRangeSet == null) {
                ModRange.$$$reportNull$$$0(25);
            }
            return longRangeSet;
        }

        @Override
        @NotNull
        public LongRangeSet mod(LongRangeSet divisor) {
            if (divisor instanceof Point) {
                int divisorValue;
                int lcm;
                Point point = (Point)divisor;
                if (point.myValue > 1L && point.myValue <= 64L && (lcm = this.lcm(divisorValue = (int)point.myValue)) <= 64) {
                    long from = MathUtil.clamp(this.myFrom, (long)(-divisorValue + 1), 0L);
                    long to = MathUtil.clamp(this.myTo, 0L, (long)(divisorValue - 1));
                    long possibleMods = this.widenBits(lcm);
                    while (64 - Long.numberOfLeadingZeros(possibleMods) > divisorValue) {
                        possibleMods = LongRangeUtil.extractBits(possibleMods, divisorValue, 64) | LongRangeUtil.extractBits(possibleMods, 0, divisorValue);
                    }
                    LongRangeSet longRangeSet = ModRange.modRange(from, to, divisorValue, possibleMods);
                    if (longRangeSet == null) {
                        ModRange.$$$reportNull$$$0(26);
                    }
                    return longRangeSet;
                }
            }
            LongRangeSet longRangeSet = ModRange.range(this.myFrom, this.myTo).mod(divisor);
            if (longRangeSet == null) {
                ModRange.$$$reportNull$$$0(27);
            }
            return longRangeSet;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
                return false;
            }
            return this.myMod == ((ModRange)o).myMod && this.myBits == ((ModRange)o).myBits;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.myMod, this.myBits);
        }

        @Override
        public String toString() {
            return super.toString() + ": " + this.getSuffix();
        }

        @Nls
        private String getSuffix() {
            String suffix = this.myMod == 2 ? (this.myBits == 1L ? InspectionsBundle.message("long.range.set.presentation.even", new Object[0]) : InspectionsBundle.message("long.range.set.presentation.odd", new Object[0])) : (this.myBits == 1L ? InspectionsBundle.message("long.range.set.presentation.divisible.by", this.myMod) : IntStreamEx.of(BitSet.valueOf(new long[]{this.myBits})).joining(", ", "<", "> mod " + this.myMod));
            return suffix;
        }

        @Override
        public LongStream stream() {
            return super.stream().filter(this::contains);
        }

        private boolean contains(long from, long to) {
            int toBit;
            if (from < this.myFrom || to > this.myTo) {
                return false;
            }
            if (to == from) {
                return this.contains(from);
            }
            if (to - from < 0L || to - from >= (long)this.myMod) {
                return false;
            }
            int fromBit = LongRangeUtil.remainder(from, this.myMod);
            if (fromBit < (toBit = LongRangeUtil.remainder(to, this.myMod))) {
                return Long.numberOfTrailingZeros(this.myBits >>> fromBit ^ 0xFFFFFFFFFFFFFFFFL) > toBit - fromBit;
            }
            return Long.numberOfTrailingZeros(this.myBits ^ 0xFFFFFFFFFFFFFFFFL) > toBit && 64 - Long.numberOfLeadingZeros((this.myBits ^ 0xFFFFFFFFFFFFFFFFL) & this.getMask()) <= fromBit;
        }

        private long widenBits(int targetMod) {
            assert (targetMod <= 64 && targetMod % this.myMod == 0);
            long result = this.myBits;
            for (int shift = targetMod - this.myMod; shift > 0; shift -= this.myMod) {
                result |= this.myBits << shift;
            }
            return result;
        }

        @Override
        LongRangeUtil.BitString getBitwiseMask() {
            int knownBits = Long.numberOfTrailingZeros(this.myMod);
            int powerOfTwo = 1 << knownBits;
            long result = -1L;
            long mask = powerOfTwo - 1;
            for (int rem = 0; rem < this.myMod; ++rem) {
                if (!LongRangeUtil.isSet(this.myBits, rem)) continue;
                int setBits = rem % powerOfTwo;
                if (result != -1L) {
                    long diffBits = result ^ (long)setBits;
                    mask &= diffBits ^ 0xFFFFFFFFFFFFFFFFL;
                }
                result = setBits;
            }
            LongRangeUtil.BitString intersection = new LongRangeUtil.BitString(result, mask).intersect(super.getBitwiseMask());
            assert (intersection != null);
            return intersection;
        }

        private long getMask() {
            return -1L >>> 64 - this.myMod;
        }

        private int lcm(int otherMod) {
            return this.myMod * otherMod / LongRangeUtil.gcd(this.myMod, otherMod);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 5, 6, 7, 8, 9, 11, 12, 13, 15, 16, 17, 18, 19, 22, 23, 24, 25, 26, 27 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fullTypeRange";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 13: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeSet$ModRange";
                    break;
                }
                case 4: 
                case 10: 
                case 14: 
                case 20: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeSet$ModRange";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentationText";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "subtract";
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "meet";
                    break;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "join";
                    break;
                }
                case 22: 
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "negate";
                    break;
                }
                case 24: 
                case 25: {
                    objectArray = objectArray2;
                    objectArray2[1] = "plus";
                    break;
                }
                case 26: 
                case 27: {
                    objectArray = objectArray2;
                    objectArray2[1] = "mod";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentationText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 13: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "subtract";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "meet";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "join";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "tryJoinExactly";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 5, 6, 7, 8, 9, 11, 12, 13, 15, 16, 17, 18, 19, 22, 23, 24, 25, 26, 27 -> new IllegalStateException(string);
            };
        }
    }

    static final class RangeSet
    extends LongRangeSet {
        final long[] myRanges;

        RangeSet(long[] ranges) {
            if (ranges.length < 4 || ranges.length % 2 != 0) {
                throw new IllegalArgumentException("Bad length: " + ranges.length + " " + Arrays.toString(ranges));
            }
            for (int i = 0; i < ranges.length; i += 2) {
                if (ranges[i + 1] < ranges[i]) {
                    throw new IllegalArgumentException("Bad sub-range #" + i / 2 + " " + Arrays.toString(ranges));
                }
                if (i <= 0 || ranges[i - 1] != Long.MAX_VALUE && 1L + ranges[i - 1] <= ranges[i]) continue;
                throw new IllegalArgumentException("Bad sub-ranges #" + (i / 2 - 1) + " and #" + i / 2 + " " + Arrays.toString(ranges));
            }
            this.myRanges = ranges;
        }

        @Override
        LongRangeUtil.BitString getBitwiseMask() {
            LongRangeUtil.BitString result = null;
            for (int i = 0; i < this.myRanges.length; i += 2) {
                LongRangeUtil.BitString newBits = LongRangeUtil.BitString.fromRange(this.myRanges[i], this.myRanges[i + 1]);
                result = result == null ? newBits : result.unite(newBits);
            }
            return result;
        }

        @Override
        @NotNull
        public LongRangeSet subtract(@NotNull LongRangeSet other) {
            if (other == null) {
                RangeSet.$$$reportNull$$$0(0);
            }
            if (other.isEmpty()) {
                RangeSet rangeSet = this;
                if (rangeSet == null) {
                    RangeSet.$$$reportNull$$$0(1);
                }
                return rangeSet;
            }
            if (other == this) {
                LongRangeSet longRangeSet = Empty.EMPTY;
                if (longRangeSet == null) {
                    RangeSet.$$$reportNull$$$0(2);
                }
                return longRangeSet;
            }
            long[] result = new long[this.myRanges.length + other.asRangeArray().length];
            int index = 0;
            for (int i = 0; i < this.myRanges.length; i += 2) {
                LongRangeSet res = RangeSet.range(this.myRanges[i], this.myRanges[i + 1]).subtract(other);
                long[] ranges = res.asRangeArray();
                System.arraycopy(ranges, 0, result, index, ranges.length);
                index += ranges.length;
            }
            LongRangeSet longRangeSet = RangeSet.fromRanges(result, index);
            if (longRangeSet == null) {
                RangeSet.$$$reportNull$$$0(3);
            }
            return longRangeSet;
        }

        @Override
        @NotNull
        public LongRangeSet meet(@NotNull LongRangeSet other) {
            if (other == null) {
                RangeSet.$$$reportNull$$$0(4);
            }
            if (other == this) {
                RangeSet rangeSet = this;
                if (rangeSet == null) {
                    RangeSet.$$$reportNull$$$0(5);
                }
                return rangeSet;
            }
            if (other.isEmpty()) {
                LongRangeSet longRangeSet = other;
                if (longRangeSet == null) {
                    RangeSet.$$$reportNull$$$0(6);
                }
                return longRangeSet;
            }
            if (other instanceof Point || other instanceof Range) {
                LongRangeSet longRangeSet = other.meet(this);
                if (longRangeSet == null) {
                    RangeSet.$$$reportNull$$$0(7);
                }
                return longRangeSet;
            }
            LongRangeSet longRangeSet = this.subtract(RangeSet.all().subtract(other));
            if (longRangeSet == null) {
                RangeSet.$$$reportNull$$$0(8);
            }
            return longRangeSet;
        }

        @Override
        @NotNull
        public LongRangeSet join(@NotNull LongRangeSet other) {
            if (other == null) {
                RangeSet.$$$reportNull$$$0(9);
            }
            if (!(other instanceof RangeSet)) {
                LongRangeSet longRangeSet = other.join(this);
                if (longRangeSet == null) {
                    RangeSet.$$$reportNull$$$0(10);
                }
                return longRangeSet;
            }
            if (other == this) {
                RangeSet rangeSet = this;
                if (rangeSet == null) {
                    RangeSet.$$$reportNull$$$0(11);
                }
                return rangeSet;
            }
            if (other.contains(this)) {
                LongRangeSet longRangeSet = other;
                if (longRangeSet == null) {
                    RangeSet.$$$reportNull$$$0(12);
                }
                return longRangeSet;
            }
            if (this.contains(other)) {
                RangeSet rangeSet = this;
                if (rangeSet == null) {
                    RangeSet.$$$reportNull$$$0(13);
                }
                return rangeSet;
            }
            LongRangeSet result = other;
            for (int i = 0; i < this.myRanges.length; i += 2) {
                result = RangeSet.range(this.myRanges[i], this.myRanges[i + 1]).join(result);
            }
            LongRangeSet longRangeSet = result;
            if (longRangeSet == null) {
                RangeSet.$$$reportNull$$$0(14);
            }
            return longRangeSet;
        }

        @Override
        @Nullable
        public LongRangeSet tryJoinExactly(@NotNull LongRangeSet other) {
            if (other == null) {
                RangeSet.$$$reportNull$$$0(15);
            }
            if (other instanceof ModRange) {
                return other.tryJoinExactly(this);
            }
            return this.join(other);
        }

        @Override
        public long min() {
            return this.myRanges[0];
        }

        @Override
        public long max() {
            return this.myRanges[this.myRanges.length - 1];
        }

        @Override
        public boolean intersects(LongRangeSet other) {
            long bTo;
            long aFrom;
            if (other.isEmpty()) {
                return false;
            }
            if (other instanceof Point) {
                Point point = (Point)other;
                return this.contains(point.myValue);
            }
            long[] otherRanges = other.asRangeArray();
            int a = 0;
            int b = 0;
            do {
                aFrom = this.myRanges[a];
                long aTo = this.myRanges[a + 1];
                long bFrom = otherRanges[b];
                bTo = otherRanges[b + 1];
                if (aFrom > bTo || bFrom > aTo) continue;
                return true;
            } while (!(aFrom > bTo ? (b += 2) >= otherRanges.length : (a += 2) >= this.myRanges.length));
            return false;
        }

        @Override
        public boolean contains(long value) {
            for (int i = 0; i < this.myRanges.length; i += 2) {
                if (value < this.myRanges[i] || value > this.myRanges[i + 1]) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(@NotNull LongRangeSet other) {
            if (other == null) {
                RangeSet.$$$reportNull$$$0(16);
            }
            if (other.isEmpty() || other == this) {
                return true;
            }
            if (other instanceof Point) {
                Point point = (Point)other;
                return this.contains(point.myValue);
            }
            LongRangeSet result = other;
            for (int i = 0; i < this.myRanges.length; i += 2) {
                if (!(result = result.subtract(RangeSet.range(this.myRanges[i], this.myRanges[i + 1]))).isEmpty()) continue;
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public String getPresentationText(@NotNull LongRangeSet fullTypeRange) {
            LongRangeSet diff;
            if (fullTypeRange == null) {
                RangeSet.$$$reportNull$$$0(17);
            }
            if ((diff = fullTypeRange.subtract(this)) instanceof Point) {
                String string = "!= " + diff.min();
                if (string == null) {
                    RangeSet.$$$reportNull$$$0(18);
                }
                return string;
            }
            if (diff instanceof Range && !diff.intersects(this)) {
                String max;
                String min;
                String string = diff.min() == fullTypeRange.min() ? "" : (min = diff.min() == fullTypeRange.min() + 1L ? LongRangeSet.formatNumber(fullTypeRange.min()) : "<= " + LongRangeSet.formatNumber(diff.min() - 1L));
                String string2 = diff.max() == fullTypeRange.max() ? "" : (max = diff.max() == fullTypeRange.max() - 1L ? LongRangeSet.formatNumber(fullTypeRange.max()) : ">= " + LongRangeSet.formatNumber(diff.max() + 1L));
                if (min.isEmpty()) {
                    String string3 = max;
                    if (string3 == null) {
                        RangeSet.$$$reportNull$$$0(19);
                    }
                    return string3;
                }
                if (max.isEmpty()) {
                    String string4 = min;
                    if (string4 == null) {
                        RangeSet.$$$reportNull$$$0(20);
                    }
                    return string4;
                }
                String string5 = InspectionsBundle.message("long.range.set.presentation.two.values", min, max);
                if (string5 == null) {
                    RangeSet.$$$reportNull$$$0(21);
                }
                return string5;
            }
            if (this.myRanges.length == 4 && this.myRanges[0] == this.myRanges[1] && this.myRanges[2] == this.myRanges[3]) {
                String string = InspectionsBundle.message("long.range.set.presentation.two.values", this.myRanges[0], this.myRanges[2]);
                if (string == null) {
                    RangeSet.$$$reportNull$$$0(22);
                }
                return string;
            }
            String string = InspectionsBundle.message("long.range.set.presentation.range", this.toString());
            if (string == null) {
                RangeSet.$$$reportNull$$$0(23);
            }
            return string;
        }

        @Override
        public boolean isCardinalityBigger(long cutoff) {
            long totalDiff = 0L;
            for (int i = 0; i < this.myRanges.length; i += 2) {
                long diff = this.myRanges[i + 1] - this.myRanges[i];
                if (diff < 0L) {
                    return true;
                }
                if ((totalDiff += diff + 1L) >= 0L && totalDiff <= cutoff) continue;
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public LongRangeSet abs(LongRangeType lrType) {
            LongRangeSet result = RangeSet.empty();
            for (int i = 0; i < this.myRanges.length; i += 2) {
                result = result.join(RangeSet.range(this.myRanges[i], this.myRanges[i + 1]).abs(lrType));
            }
            LongRangeSet longRangeSet = result;
            if (longRangeSet == null) {
                RangeSet.$$$reportNull$$$0(24);
            }
            return longRangeSet;
        }

        @Override
        @NotNull
        public LongRangeSet negate(LongRangeType lrType) {
            LongRangeSet result = RangeSet.empty();
            for (int i = 0; i < this.myRanges.length; i += 2) {
                result = result.join(RangeSet.range(this.myRanges[i], this.myRanges[i + 1]).negate(lrType));
            }
            LongRangeSet longRangeSet = result;
            if (longRangeSet == null) {
                RangeSet.$$$reportNull$$$0(25);
            }
            return longRangeSet;
        }

        @Override
        @NotNull
        public LongRangeSet plus(LongRangeSet other, LongRangeType lrType) {
            if (this.myRanges.length > 6) {
                LongRangeSet longRangeSet = RangeSet.range(this.min(), this.max()).plus(other, lrType);
                if (longRangeSet == null) {
                    RangeSet.$$$reportNull$$$0(26);
                }
                return longRangeSet;
            }
            LongRangeSet result = RangeSet.empty();
            for (int i = 0; i < this.myRanges.length; i += 2) {
                result = result.join(RangeSet.range(this.myRanges[i], this.myRanges[i + 1]).plus(other, lrType));
            }
            LongRangeSet longRangeSet = result;
            if (longRangeSet == null) {
                RangeSet.$$$reportNull$$$0(27);
            }
            return longRangeSet;
        }

        @Override
        @NotNull
        public LongRangeSet mod(LongRangeSet divisor) {
            if (divisor.isEmpty()) {
                LongRangeSet longRangeSet = RangeSet.empty();
                if (longRangeSet == null) {
                    RangeSet.$$$reportNull$$$0(28);
                }
                return longRangeSet;
            }
            LongRangeSet result = RangeSet.empty();
            for (int i = 0; i < this.myRanges.length; i += 2) {
                result = result.join(RangeSet.range(this.myRanges[i], this.myRanges[i + 1]).mod(divisor));
            }
            LongRangeSet longRangeSet = result;
            if (longRangeSet == null) {
                RangeSet.$$$reportNull$$$0(29);
            }
            return longRangeSet;
        }

        @Override
        public LongStream stream() {
            return IntStream.range(0, this.myRanges.length / 2).mapToObj(idx -> LongStream.rangeClosed(this.myRanges[idx * 2], this.myRanges[idx * 2 + 1])).reduce(LongStream::concat).orElseGet(LongStream::empty);
        }

        @Override
        @NotNull
        public List<LongRangeSet> asRanges() {
            List<LongRangeSet> list = IntStream.range(0, this.myRanges.length / 2).mapToObj(idx -> RangeSet.range(this.myRanges[idx * 2], this.myRanges[idx * 2 + 1])).collect(Collectors.toList());
            if (list == null) {
                RangeSet.$$$reportNull$$$0(30);
            }
            return list;
        }

        @Override
        long[] asRangeArray() {
            return this.myRanges;
        }

        public int hashCode() {
            return Arrays.hashCode(this.myRanges);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RangeSet)) return false;
            RangeSet rangeSet = (RangeSet)o;
            if (!Arrays.equals(this.myRanges, rangeSet.myRanges)) return false;
            return true;
        }

        public String toString() {
            StringJoiner sb = new StringJoiner(", ", "{", "}");
            for (int i = 0; i < this.myRanges.length; i += 2) {
                sb.add(LongRangeSet.toString(this.myRanges[i], this.myRanges[i + 1]));
            }
            return sb.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 5, 6, 7, 8, 10, 11, 12, 13, 14, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeSet$RangeSet";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fullTypeRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeSet$RangeSet";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "subtract";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "meet";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "join";
                    break;
                }
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentationText";
                    break;
                }
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[1] = "abs";
                    break;
                }
                case 25: {
                    objectArray = objectArray2;
                    objectArray2[1] = "negate";
                    break;
                }
                case 26: 
                case 27: {
                    objectArray = objectArray2;
                    objectArray2[1] = "plus";
                    break;
                }
                case 28: 
                case 29: {
                    objectArray = objectArray2;
                    objectArray2[1] = "mod";
                    break;
                }
                case 30: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asRanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "subtract";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "meet";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "join";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "tryJoinExactly";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentationText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 5, 6, 7, 8, 10, 11, 12, 13, 14, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30 -> new IllegalStateException(string);
            };
        }
    }

    static class Range
    extends LongRangeSet {
        static final Range LONG_RANGE = new Range(Long.MIN_VALUE, Long.MAX_VALUE);
        static final Range INT_RANGE = new Range(Integer.MIN_VALUE, Integer.MAX_VALUE);
        final long myFrom;
        final long myTo;

        Range(long from, long to) {
            if (to <= from) {
                throw new IllegalArgumentException(to + "<=" + from);
            }
            this.myFrom = from;
            this.myTo = to;
        }

        @Override
        @NotNull
        public String getPresentationText(@NotNull LongRangeSet fullTypeRange) {
            if (fullTypeRange == null) {
                Range.$$$reportNull$$$0(0);
            }
            if (fullTypeRange.min() == this.myFrom) {
                if (fullTypeRange.max() == this.myTo) {
                    String string = InspectionsBundle.message("long.range.set.presentation.any", new Object[0]);
                    if (string == null) {
                        Range.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                String string = "<= " + LongRangeSet.formatNumber(this.myTo);
                if (string == null) {
                    Range.$$$reportNull$$$0(2);
                }
                return string;
            }
            if (fullTypeRange.max() == this.myTo) {
                String string = ">= " + LongRangeSet.formatNumber(this.myFrom);
                if (string == null) {
                    Range.$$$reportNull$$$0(3);
                }
                return string;
            }
            if (this.myTo - this.myFrom == 1L) {
                String string = InspectionsBundle.message("long.range.set.presentation.two.values", this.myFrom, this.myTo);
                if (string == null) {
                    Range.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = InspectionsBundle.message("long.range.set.presentation.range", this.toString());
            if (string == null) {
                Range.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Override
        public boolean isCardinalityBigger(long cutoff) {
            long diff = this.myTo - this.myFrom;
            return diff < 0L || diff >= cutoff;
        }

        @Override
        @NotNull
        public LongRangeSet subtract(@NotNull LongRangeSet other) {
            if (other == null) {
                Range.$$$reportNull$$$0(6);
            }
            if (other.isEmpty()) {
                Range range = this;
                if (range == null) {
                    Range.$$$reportNull$$$0(7);
                }
                return range;
            }
            if (other == this) {
                LongRangeSet longRangeSet = Empty.EMPTY;
                if (longRangeSet == null) {
                    Range.$$$reportNull$$$0(8);
                }
                return longRangeSet;
            }
            if (other instanceof Point) {
                Point point = (Point)other;
                long value = point.myValue;
                if (value < this.myFrom || value > this.myTo) {
                    Range range = this;
                    if (range == null) {
                        Range.$$$reportNull$$$0(9);
                    }
                    return range;
                }
                if (value == this.myFrom) {
                    LongRangeSet longRangeSet = Range.range(this.myFrom + 1L, this.myTo);
                    if (longRangeSet == null) {
                        Range.$$$reportNull$$$0(10);
                    }
                    return longRangeSet;
                }
                if (value == this.myTo) {
                    LongRangeSet longRangeSet = Range.range(this.myFrom, this.myTo - 1L);
                    if (longRangeSet == null) {
                        Range.$$$reportNull$$$0(11);
                    }
                    return longRangeSet;
                }
                return new RangeSet(new long[]{this.myFrom, value - 1L, value + 1L, this.myTo});
            }
            if (other instanceof Range) {
                Range range = (Range)other;
                LongRangeSet toJoin = Empty.EMPTY;
                long from = range.myFrom;
                long to = range.myTo;
                if (to < this.myFrom || from > this.myTo) {
                    Range range2 = this;
                    if (range2 == null) {
                        Range.$$$reportNull$$$0(12);
                    }
                    return range2;
                }
                if (other instanceof ModRange) {
                    ModRange modRange = (ModRange)other;
                    long newBits = modRange.myBits ^ 0xFFFFFFFFFFFFFFFFL;
                    if (modRange.myMod < 64) {
                        newBits &= (1L << modRange.myMod) - 1L;
                    }
                    toJoin = Range.modRange(Math.max(from, this.myFrom), Math.min(to, this.myTo), modRange.myMod, newBits);
                }
                if (from <= this.myFrom && to >= this.myTo) {
                    LongRangeSet longRangeSet = toJoin;
                    if (longRangeSet == null) {
                        Range.$$$reportNull$$$0(13);
                    }
                    return longRangeSet;
                }
                if (from > this.myFrom && to < this.myTo) {
                    LongRangeSet longRangeSet = new RangeSet(new long[]{this.myFrom, from - 1L, to + 1L, this.myTo}).join(toJoin);
                    if (longRangeSet == null) {
                        Range.$$$reportNull$$$0(14);
                    }
                    return longRangeSet;
                }
                if (from <= this.myFrom) {
                    LongRangeSet longRangeSet = Range.range(to + 1L, this.myTo).join(toJoin);
                    if (longRangeSet == null) {
                        Range.$$$reportNull$$$0(15);
                    }
                    return longRangeSet;
                }
                assert (to >= this.myTo);
                LongRangeSet longRangeSet = Range.range(this.myFrom, from - 1L).join(toJoin);
                if (longRangeSet == null) {
                    Range.$$$reportNull$$$0(16);
                }
                return longRangeSet;
            }
            long[] ranges = ((RangeSet)other).myRanges;
            LongRangeSet result = this;
            for (int i = 0; i < ranges.length; i += 2) {
                if (!(result = result.subtract(Range.range(ranges[i], ranges[i + 1]))).isEmpty()) continue;
                LongRangeSet longRangeSet = result;
                if (longRangeSet == null) {
                    Range.$$$reportNull$$$0(17);
                }
                return longRangeSet;
            }
            Range range = result;
            if (range == null) {
                Range.$$$reportNull$$$0(18);
            }
            return range;
        }

        @Override
        @NotNull
        public LongRangeSet meet(@NotNull LongRangeSet other) {
            if (other == null) {
                Range.$$$reportNull$$$0(19);
            }
            if (other == this) {
                Range range = this;
                if (range == null) {
                    Range.$$$reportNull$$$0(20);
                }
                return range;
            }
            if (other.isEmpty()) {
                LongRangeSet longRangeSet = other;
                if (longRangeSet == null) {
                    Range.$$$reportNull$$$0(21);
                }
                return longRangeSet;
            }
            if (other instanceof ModRange && !(this instanceof ModRange) || other instanceof Point) {
                LongRangeSet longRangeSet = other.meet(this);
                if (longRangeSet == null) {
                    Range.$$$reportNull$$$0(22);
                }
                return longRangeSet;
            }
            if (other instanceof Range) {
                Range range = (Range)other;
                long from = range.myFrom;
                long to = range.myTo;
                if (from <= this.myFrom && to >= this.myTo) {
                    Range range2 = this;
                    if (range2 == null) {
                        Range.$$$reportNull$$$0(23);
                    }
                    return range2;
                }
                if (from >= this.myFrom && to <= this.myTo) {
                    LongRangeSet longRangeSet = other;
                    if (longRangeSet == null) {
                        Range.$$$reportNull$$$0(24);
                    }
                    return longRangeSet;
                }
                if (from < this.myFrom) {
                    from = this.myFrom;
                }
                if (to > this.myTo) {
                    to = this.myTo;
                }
                LongRangeSet longRangeSet = from <= to ? Range.range(from, to) : Empty.EMPTY;
                if (longRangeSet == null) {
                    Range.$$$reportNull$$$0(25);
                }
                return longRangeSet;
            }
            long[] ranges = ((RangeSet)other).myRanges;
            long[] result = new long[ranges.length];
            int index = 0;
            for (int i = 0; i < ranges.length; i += 2) {
                long[] res = this.meet(Range.range(ranges[i], ranges[i + 1])).asRangeArray();
                System.arraycopy(res, 0, result, index, res.length);
                index += res.length;
            }
            LongRangeSet longRangeSet = Range.fromRanges(result, index);
            if (longRangeSet == null) {
                Range.$$$reportNull$$$0(26);
            }
            return longRangeSet;
        }

        @Override
        @NotNull
        public LongRangeSet join(@NotNull LongRangeSet other) {
            int maxIndex;
            if (other == null) {
                Range.$$$reportNull$$$0(27);
            }
            if (other.isEmpty() || other == this) {
                Range range = this;
                if (range == null) {
                    Range.$$$reportNull$$$0(28);
                }
                return range;
            }
            if (other instanceof Point) {
                LongRangeSet longRangeSet = other.join(this);
                if (longRangeSet == null) {
                    Range.$$$reportNull$$$0(29);
                }
                return longRangeSet;
            }
            if (other instanceof Range) {
                if (other.min() <= this.max() && this.min() <= other.max() || other.max() < this.min() && other.max() + 1L == this.min() || other.min() > this.max() && this.max() + 1L == other.min()) {
                    LongRangeSet longRangeSet = Range.range(Math.min(this.min(), other.min()), Math.max(this.max(), other.max()));
                    if (longRangeSet == null) {
                        Range.$$$reportNull$$$0(30);
                    }
                    return longRangeSet;
                }
                if (other.max() < this.min()) {
                    return new RangeSet(new long[]{other.min(), other.max(), this.min(), this.max()});
                }
                return new RangeSet(new long[]{this.min(), this.max(), other.min(), other.max()});
            }
            long[] longs = other.asRangeArray();
            int minIndex = Arrays.binarySearch(longs, this.min());
            if (minIndex < 0) {
                if ((minIndex = -minIndex - 1) % 2 == 0 && minIndex > 0 && longs[minIndex - 1] + 1L == this.min()) {
                    --minIndex;
                }
            } else if (minIndex % 2 == 0) {
                ++minIndex;
            }
            if ((maxIndex = Arrays.binarySearch(longs, this.max())) < 0) {
                if ((maxIndex = -maxIndex - 1) % 2 == 0 && maxIndex < longs.length && this.max() + 1L == longs[maxIndex]) {
                    ++maxIndex;
                }
            } else if (maxIndex % 2 == 0) {
                ++maxIndex;
            }
            long[] result = new long[longs.length + 2];
            System.arraycopy(longs, 0, result, 0, minIndex);
            int pos = minIndex;
            if (minIndex % 2 == 0) {
                result[pos++] = this.min();
            }
            if (maxIndex % 2 == 0) {
                result[pos++] = this.max();
            }
            System.arraycopy(longs, maxIndex, result, pos, longs.length - maxIndex);
            LongRangeSet longRangeSet = Range.fromRanges(result, longs.length + pos - maxIndex);
            if (longRangeSet == null) {
                Range.$$$reportNull$$$0(31);
            }
            return longRangeSet;
        }

        @Override
        @Nullable
        public LongRangeSet tryJoinExactly(@NotNull LongRangeSet other) {
            if (other == null) {
                Range.$$$reportNull$$$0(32);
            }
            if (other instanceof ModRange) {
                return other.tryJoinExactly(this);
            }
            return this.join(other);
        }

        @Override
        public long min() {
            return this.myFrom;
        }

        @Override
        public long max() {
            return this.myTo;
        }

        @Override
        public boolean intersects(LongRangeSet other) {
            if (other.isEmpty()) {
                return false;
            }
            if (other instanceof RangeSet) {
                RangeSet rangeSet = (RangeSet)other;
                long[] otherRanges = rangeSet.myRanges;
                for (int i = 0; i < otherRanges.length && otherRanges[i] <= this.myTo; i += 2) {
                    if (this.myTo < otherRanges[i] || this.myFrom > otherRanges[i + 1]) continue;
                    return true;
                }
                return false;
            }
            return this.myTo >= other.min() && this.myFrom <= other.max();
        }

        @Override
        public boolean contains(long value) {
            return this.myFrom <= value && this.myTo >= value;
        }

        @Override
        public boolean contains(@NotNull LongRangeSet other) {
            if (other == null) {
                Range.$$$reportNull$$$0(33);
            }
            return other.isEmpty() || other.min() >= this.myFrom && other.max() <= this.myTo;
        }

        @Override
        @NotNull
        public LongRangeSet abs(LongRangeType lrType) {
            if (this.myFrom >= 0L) {
                Range range = this;
                if (range == null) {
                    Range.$$$reportNull$$$0(34);
                }
                return range;
            }
            long minValue = lrType.min();
            long low = this.myFrom;
            long hi = this.myTo;
            if (low <= minValue) {
                low = minValue + 1L;
            }
            if (this.myTo <= 0L) {
                hi = -low;
                low = -this.myTo;
            } else {
                hi = Math.max(-low, hi);
                low = 0L;
            }
            if (low > hi) {
                LongRangeSet longRangeSet = lrType.fullRange();
                if (longRangeSet == null) {
                    Range.$$$reportNull$$$0(35);
                }
                return longRangeSet;
            }
            if (this.myFrom <= minValue) {
                return new RangeSet(new long[]{minValue, minValue, low, hi});
            }
            return new Range(low, hi);
        }

        @Override
        @NotNull
        public LongRangeSet negate(LongRangeType lrType) {
            long minValue = lrType.min();
            if (this.myFrom <= minValue) {
                if (this.myTo >= lrType.max()) {
                    LongRangeSet longRangeSet = lrType.fullRange();
                    if (longRangeSet == null) {
                        Range.$$$reportNull$$$0(36);
                    }
                    return longRangeSet;
                }
                return new RangeSet(new long[]{minValue, minValue, -this.myTo, -(minValue + 1L)});
            }
            return new Range(-this.myTo, -this.myFrom);
        }

        @Override
        @NotNull
        public LongRangeSet plus(LongRangeSet other, LongRangeType lrType) {
            block10: {
                block9: {
                    if (other.isEmpty()) {
                        LongRangeSet longRangeSet = other;
                        if (longRangeSet == null) {
                            Range.$$$reportNull$$$0(37);
                        }
                        return longRangeSet;
                    }
                    if (this.equals(lrType.fullRange())) {
                        Range range = this;
                        if (range == null) {
                            Range.$$$reportNull$$$0(38);
                        }
                        return range;
                    }
                    if (other instanceof Point || other instanceof Range) break block9;
                    if (!(other instanceof RangeSet)) break block10;
                    RangeSet rangeSet = (RangeSet)other;
                    if (rangeSet.myRanges.length <= 6) break block10;
                }
                return Range.plus(this.myFrom, this.myTo, other.min(), other.max(), lrType);
            }
            long[] ranges = other.asRangeArray();
            LongRangeSet result = Range.empty();
            for (int i = 0; i < ranges.length; i += 2) {
                result = result.join(Range.plus(this.myFrom, this.myTo, ranges[i], ranges[i + 1], lrType));
            }
            LongRangeSet longRangeSet = result;
            if (longRangeSet == null) {
                Range.$$$reportNull$$$0(39);
            }
            return longRangeSet;
        }

        @NotNull
        private static LongRangeSet plus(long from1, long to1, long from2, long to2, LongRangeType lrType) {
            long len1 = to1 - from1;
            long len2 = to2 - from2;
            if (len1 < 0L && len2 < 0L || (len1 < 0L || len2 < 0L) && len1 + len2 + 1L >= 0L) {
                LongRangeSet longRangeSet = lrType.fullRange();
                if (longRangeSet == null) {
                    Range.$$$reportNull$$$0(40);
                }
                return longRangeSet;
            }
            long from = from1 + from2;
            long to = to1 + to2;
            assert (lrType == LongRangeType.INT64 || lrType == LongRangeType.INT32);
            if (lrType == LongRangeType.INT32) {
                if (to - from + 1L >= 0x100000000L) {
                    Range range = INT_RANGE;
                    if (range == null) {
                        Range.$$$reportNull$$$0(41);
                    }
                    return range;
                }
                from = (int)from;
                to = (int)to;
            }
            if (to < from) {
                return new RangeSet(new long[]{lrType.min(), to, from, lrType.max()});
            }
            LongRangeSet longRangeSet = Range.range(from, to);
            if (longRangeSet == null) {
                Range.$$$reportNull$$$0(42);
            }
            return longRangeSet;
        }

        @Override
        @NotNull
        public LongRangeSet mod(LongRangeSet divisor) {
            long minDivisor;
            if (divisor.isEmpty() || divisor.equals(Point.ZERO)) {
                LongRangeSet longRangeSet = Range.empty();
                if (longRangeSet == null) {
                    Range.$$$reportNull$$$0(43);
                }
                return longRangeSet;
            }
            if (divisor instanceof Point) {
                Point point = (Point)divisor;
                if (point.myValue == Long.MIN_VALUE) {
                    LongRangeSet longRangeSet = this.contains(Long.MIN_VALUE) ? this.subtract(divisor).join(Point.ZERO) : this;
                    if (longRangeSet == null) {
                        Range.$$$reportNull$$$0(44);
                    }
                    return longRangeSet;
                }
            }
            if (divisor.contains(Long.MIN_VALUE)) {
                LongRangeSet longRangeSet = this.possibleMod();
                if (longRangeSet == null) {
                    Range.$$$reportNull$$$0(45);
                }
                return longRangeSet;
            }
            long min = divisor.min();
            long max = divisor.max();
            long maxDivisor = Math.max(Math.abs(min), Math.abs(max));
            long l = min > 0L ? min : (minDivisor = max < 0L ? Math.abs(max) : 0L);
            if (!this.intersects(LongRangeSet.range(Long.MIN_VALUE, -minDivisor)) && !this.intersects(LongRangeSet.range(minDivisor, Long.MAX_VALUE))) {
                Range range = this;
                if (range == null) {
                    Range.$$$reportNull$$$0(46);
                }
                return range;
            }
            LongRangeSet longRangeSet = this.possibleMod().meet(Range.range(-maxDivisor + 1L, maxDivisor - 1L));
            if (longRangeSet == null) {
                Range.$$$reportNull$$$0(47);
            }
            return longRangeSet;
        }

        private LongRangeSet possibleMod() {
            if (this.contains(0L)) {
                return this;
            }
            if (this.min() > 0L) {
                return Range.range(0L, this.max());
            }
            return Range.range(this.min(), 0L);
        }

        @Override
        public LongStream stream() {
            return LongStream.rangeClosed(this.myFrom, this.myTo);
        }

        @Override
        @NotNull
        public List<LongRangeSet> asRanges() {
            List<LongRangeSet> list = Collections.singletonList(this);
            if (list == null) {
                Range.$$$reportNull$$$0(48);
            }
            return list;
        }

        @Override
        long[] asRangeArray() {
            return new long[]{this.myFrom, this.myTo};
        }

        public int hashCode() {
            return Long.hashCode(this.myFrom) * 1337 + Long.hashCode(this.myTo);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o != null && o.getClass() == this.getClass() && this.myFrom == ((Range)o).myFrom && this.myTo == ((Range)o).myTo;
        }

        @NlsSafe
        public String toString() {
            return "{" + Range.toString(this.myFrom, this.myTo) + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 20, 21, 22, 23, 24, 25, 26, 28, 29, 30, 31, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fullTypeRange";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeSet$Range";
                    break;
                }
                case 6: 
                case 19: 
                case 27: 
                case 32: 
                case 33: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeSet$Range";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentationText";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "subtract";
                    break;
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    objectArray = objectArray2;
                    objectArray2[1] = "meet";
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    objectArray = objectArray2;
                    objectArray2[1] = "join";
                    break;
                }
                case 34: 
                case 35: {
                    objectArray = objectArray2;
                    objectArray2[1] = "abs";
                    break;
                }
                case 36: {
                    objectArray = objectArray2;
                    objectArray2[1] = "negate";
                    break;
                }
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: {
                    objectArray = objectArray2;
                    objectArray2[1] = "plus";
                    break;
                }
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: {
                    objectArray = objectArray2;
                    objectArray2[1] = "mod";
                    break;
                }
                case 48: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asRanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentationText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "subtract";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "meet";
                    break;
                }
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "join";
                    break;
                }
                case 32: {
                    objectArray = objectArray;
                    objectArray[2] = "tryJoinExactly";
                    break;
                }
                case 33: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 20, 21, 22, 23, 24, 25, 26, 28, 29, 30, 31, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48 -> new IllegalStateException(string);
            };
        }
    }
}

