/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.lang.ir;

import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DataFlowIRProvider {
    public static final LanguageExtension<DataFlowIRProvider> EP_NAME = new LanguageExtension("com.intellij.dataflowIRProvider");

    @Nullable
    public ControlFlow createControlFlow(@NotNull DfaValueFactory var1, @NotNull PsiElement var2);

    @NotNull
    default public Collection<TextRange> unreachableSegments(@NotNull PsiElement startAnchor, @NotNull Set<PsiElement> unreachableElements) {
        if (startAnchor == null) {
            DataFlowIRProvider.$$$reportNull$$$0(0);
        }
        if (unreachableElements == null) {
            DataFlowIRProvider.$$$reportNull$$$0(1);
        }
        List<TextRange> list = Collections.emptyList();
        if (list == null) {
            DataFlowIRProvider.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public static ControlFlow forElement(@NotNull PsiElement psiBlock, @NotNull DfaValueFactory targetFactory) {
        PsiFile file;
        DataFlowIRProvider provider;
        if (psiBlock == null) {
            DataFlowIRProvider.$$$reportNull$$$0(3);
        }
        if (targetFactory == null) {
            DataFlowIRProvider.$$$reportNull$$$0(4);
        }
        if ((provider = EP_NAME.forLanguage((file = psiBlock.getContainingFile()).getLanguage())) == null) {
            return null;
        }
        ConcurrentHashMap fileMap = (ConcurrentHashMap)CachedValuesManager.getCachedValue(file, () -> CachedValueProvider.Result.create(new ConcurrentHashMap(), PsiModificationTracker.MODIFICATION_COUNT));
        return fileMap.computeIfAbsent(psiBlock, psi -> {
            DfaValueFactory factory = new DfaValueFactory(file.getProject());
            ControlFlow flow = provider.createControlFlow(factory, psiBlock);
            return Optional.ofNullable(flow);
        }).map(flow -> new ControlFlow((ControlFlow)flow, targetFactory)).orElse(null);
    }

    @NotNull
    public static Collection<TextRange> computeUnreachableSegments(@NotNull PsiElement startAnchor, @NotNull Set<PsiElement> unreachableElements) {
        PsiFile file;
        DataFlowIRProvider provider;
        if (startAnchor == null) {
            DataFlowIRProvider.$$$reportNull$$$0(5);
        }
        if (unreachableElements == null) {
            DataFlowIRProvider.$$$reportNull$$$0(6);
        }
        if ((provider = EP_NAME.forLanguage((file = startAnchor.getContainingFile()).getLanguage())) == null) {
            List<TextRange> list = Collections.emptyList();
            if (list == null) {
                DataFlowIRProvider.$$$reportNull$$$0(7);
            }
            return list;
        }
        Collection<TextRange> collection = provider.unreachableSegments(startAnchor, unreachableElements);
        if (collection == null) {
            DataFlowIRProvider.$$$reportNull$$$0(8);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startAnchor";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unreachableElements";
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/lang/ir/DataFlowIRProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiBlock";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/lang/ir/DataFlowIRProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "unreachableSegments";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "computeUnreachableSegments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "unreachableSegments";
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeUnreachableSegments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7, 8 -> new IllegalStateException(string);
        };
    }
}

