/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.quickfix;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ReflectionUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UnresolvedReferenceQuickFixProvider<T extends PsiReference> {
    private static final ExtensionPointName<UnresolvedReferenceQuickFixProvider<?>> EP_NAME = ExtensionPointName.create("com.intellij.codeInsight.unresolvedReferenceQuickFixProvider");

    @ApiStatus.Internal
    public static <T extends PsiReference> boolean registerReferenceFixes(@NotNull T ref, final @NotNull QuickFixActionRegistrar registrar) {
        if (ref == null) {
            UnresolvedReferenceQuickFixProvider.$$$reportNull$$$0(0);
        }
        if (registrar == null) {
            UnresolvedReferenceQuickFixProvider.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        DumbService dumbService = DumbService.getInstance(ref.getElement().getProject());
        Class<?> referenceClass = ref.getClass();
        final AtomicBoolean registered = new AtomicBoolean();
        QuickFixActionRegistrar registrarDelegate = new QuickFixActionRegistrar(){

            @Override
            public void register(@NotNull IntentionAction action2) {
                if (action2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                registrar.register(action2);
                registered.set(true);
            }

            @Override
            public void register(@NotNull TextRange fixRange, @NotNull IntentionAction action2, @Nullable HighlightDisplayKey key) {
                if (fixRange == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (action2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                registrar.register(fixRange, action2, key);
                registered.set(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "action";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fixRange";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/quickfix/UnresolvedReferenceQuickFixProvider$1";
                objectArray[2] = "register";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        EP_NAME.forEachExtensionSafe(each -> {
            if (!dumbService.isUsableInCurrentContext(each)) {
                return;
            }
            if (ReflectionUtil.isAssignable(each.getReferenceClass(), referenceClass)) {
                each.registerFixes(ref, registrarDelegate);
            }
        });
        return registered.get();
    }

    @ApiStatus.Internal
    public static void registerUnresolvedReferenceLazyQuickFixes(@NotNull PsiReference reference, @NotNull HighlightInfo.Builder builder) {
        if (reference == null) {
            UnresolvedReferenceQuickFixProvider.$$$reportNull$$$0(2);
        }
        if (builder == null) {
            UnresolvedReferenceQuickFixProvider.$$$reportNull$$$0(3);
        }
        Consumer<QuickFixActionRegistrar> consumer = registrar -> {
            Project myProject;
            ApplicationManager.getApplication().assertIsNonDispatchThread();
            ApplicationManager.getApplication().assertReadAccessAllowed();
            PsiElement referenceElement = reference.getElement();
            if (!referenceElement.isValid() || (myProject = referenceElement.getProject()).isDisposed() || DumbService.getInstance(myProject).isDumb()) {
                return;
            }
            boolean wasRegistered = UnresolvedReferenceQuickFixProvider.registerReferenceFixes(reference, registrar);
            if (wasRegistered) {
                DaemonCodeAnalyzerEx.getInstanceEx(myProject).rescheduleShowIntentionsPass(referenceElement.getContainingFile(), builder);
            }
        };
        builder.registerLazyFixes(consumer);
    }

    public abstract void registerFixes(@NotNull T var1, @NotNull QuickFixActionRegistrar var2);

    @NotNull
    public abstract Class<T> getReferenceClass();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/quickfix/UnresolvedReferenceQuickFixProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerReferenceFixes";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "registerUnresolvedReferenceLazyQuickFixes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

