/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.multiverse;

import com.intellij.codeInsight.multiverse.CodeInsightContext;
import com.intellij.codeInsight.multiverse.CodeInsightContextChangeListener;
import com.intellij.codeInsight.multiverse.CodeInsightContextManager;
import com.intellij.codeInsight.multiverse.CodeInsightContexts;
import com.intellij.codeInsight.multiverse.EditorContextManager;
import com.intellij.codeInsight.multiverse.EditorContextManagerImplKt;
import com.intellij.codeInsight.multiverse.EditorSelectedContexts;
import com.intellij.codeInsight.multiverse.SingleEditorContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.AtomicMapCache;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.CollectionFactory;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000bH\u0017J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000bH\u0003J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000eH\u0016J\u0018\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000RT\u0010\t\u001aH\u0012\u000e\u0012\f0\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\r\u0012\u000e\u0012\f0\u000e\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\r\u0012$\u0012\"\u0012\u000e\u0012\f0\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\r\u0012\u000e\u0012\f0\u000e\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\r0\u000f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001f"}, d2={"Lcom/intellij/codeInsight/multiverse/EditorContextManagerImpl;", "Lcom/intellij/codeInsight/multiverse/EditorContextManager;", "Lcom/intellij/openapi/Disposable$Default;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "currentContextCache", "Lcom/intellij/util/AtomicMapCache;", "Lcom/intellij/openapi/editor/Editor;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lcom/intellij/codeInsight/multiverse/EditorSelectedContexts;", "Ljava/util/concurrent/ConcurrentMap;", "_eventFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/intellij/codeInsight/multiverse/EditorContextManager$ChangeEvent;", "getCachedEditorContexts", "editor", "getEditorContexts", "getCurrentContextStateWithPreferredDefault", "setEditorContext", "", "contexts", "eventFlow", "Lkotlinx/coroutines/flow/Flow;", "getEventFlow", "()Lkotlinx/coroutines/flow/Flow;", "fireEvent", "intellij.platform.analysis.impl"})
public final class EditorContextManagerImpl
implements EditorContextManager,
Disposable.Default {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final AtomicMapCache<Editor, EditorSelectedContexts, ConcurrentMap<Editor, EditorSelectedContexts>> currentContextCache;
    @NotNull
    private final MutableSharedFlow<EditorContextManager.ChangeEvent> _eventFlow;

    public EditorContextManagerImpl(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project;
        this.cs = cs;
        this.currentContextCache = new AtomicMapCache(EditorContextManagerImpl::currentContextCache$lambda$0);
        this._eventFlow = SharedFlowKt.MutableSharedFlow$default(0, Integer.MAX_VALUE, null, 5, null);
        BuildersKt.launch$default(this.cs, null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ EditorContextManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$launch;
                        ResultKt.throwOnFailure((Object)$result);
                        this.this$0.project.getMessageBus().connect((CoroutineScope)$this$launch).subscribe(CodeInsightContextManager.Companion.getTopic(), new CodeInsightContextChangeListener(){

                            @Override
                            public void contextsChanged() {
                                this$0.currentContextCache.invalidate();
                            }
                        });
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    @Nullable
    public EditorSelectedContexts getCachedEditorContexts(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return this.currentContextCache.get(editor);
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    @NotNull
    public EditorSelectedContexts getEditorContexts(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return this.getCurrentContextStateWithPreferredDefault(editor);
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    private final EditorSelectedContexts getCurrentContextStateWithPreferredDefault(Editor editor) {
        if (!CodeInsightContexts.isSharedSourceSupportEnabled(this.project)) {
            return (EditorSelectedContexts)new SingleEditorContext(CodeInsightContexts.defaultContext());
        }
        EditorSelectedContexts editorSelectedContexts = this.currentContextCache.computeIfAbsent(editor, (Function0<EditorSelectedContexts>)((Function0)() -> EditorContextManagerImpl.getCurrentContextStateWithPreferredDefault$lambda$1(editor, this)));
        Intrinsics.checkNotNullExpressionValue((Object)editorSelectedContexts, (String)"computeIfAbsent(...)");
        return editorSelectedContexts;
    }

    public void setEditorContext(@NotNull Editor editor, @NotNull EditorSelectedContexts contexts2) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)contexts2, (String)"contexts");
        this.currentContextCache.set(editor, contexts2);
        this.fireEvent(editor, contexts2);
    }

    @NotNull
    public Flow<EditorContextManager.ChangeEvent> getEventFlow() {
        return FlowKt.asSharedFlow(this._eventFlow);
    }

    private final void fireEvent(Editor editor, EditorSelectedContexts contexts2) {
        EditorContextManager.ChangeEvent event = new EditorContextManager.ChangeEvent(editor, contexts2);
        ((EditorContextManager.ChangeEventListener)this.project.getMessageBus().syncPublisher(EditorContextManager.Companion.getTopic())).editorContextsChanged(event);
        if (!this._eventFlow.tryEmit(event)) {
            EditorContextManagerImplKt.access$getLog$p().error("Failed to emit event: " + event);
        }
    }

    private static final ConcurrentMap currentContextCache$lambda$0() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, (String)"createConcurrentWeakMap(...)");
        return concurrentMap;
    }

    private static final EditorSelectedContexts getCurrentContextStateWithPreferredDefault$lambda$1(Editor $editor, EditorContextManagerImpl this$0) {
        VirtualFile file = FileDocumentManager.getInstance().getFile($editor.getDocument());
        if (file == null) {
            return (EditorSelectedContexts)new SingleEditorContext(CodeInsightContexts.defaultContext());
        }
        CodeInsightContext preferredContext = CodeInsightContextManager.Companion.getInstance(this$0.project).getPreferredContext(file);
        SingleEditorContext contexts2 = new SingleEditorContext(preferredContext);
        this$0.fireEvent($editor, (EditorSelectedContexts)contexts2);
        return (EditorSelectedContexts)contexts2;
    }
}

