/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.AnnotationSessionImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightInfoHolder {
    private final PsiFile myContextFile;
    @NotNull
    private final @NotNull HighlightInfoFilter @NotNull [] myFilters;
    private final AnnotationSession myAnnotationSession;
    private int myErrorCount;
    private final List<HighlightInfo> myInfos;

    public HighlightInfoHolder(@NotNull PsiFile contextFile, HighlightInfoFilter ... filters) {
        if (contextFile == null) {
            HighlightInfoHolder.$$$reportNull$$$0(0);
        }
        if (filters == null) {
            HighlightInfoHolder.$$$reportNull$$$0(1);
        }
        this.myContextFile = contextFile;
        this.myAnnotationSession = AnnotationSessionImpl.create(contextFile);
        this.myFilters = filters;
        this.myInfos = new ArrayList<HighlightInfo>(Math.max(10, contextFile.getTextLength() / 800));
    }

    @NotNull
    public AnnotationSession getAnnotationSession() {
        AnnotationSession annotationSession = this.myAnnotationSession;
        if (annotationSession == null) {
            HighlightInfoHolder.$$$reportNull$$$0(2);
        }
        return annotationSession;
    }

    public boolean add(@Nullable HighlightInfo info) {
        if (info == null || !this.accepted(info)) {
            return false;
        }
        HighlightSeverity severity = info.getSeverity();
        if (severity == HighlightSeverity.ERROR) {
            ++this.myErrorCount;
        }
        return this.myInfos.add(info);
    }

    public void clear() {
        this.myErrorCount = 0;
        this.myInfos.clear();
    }

    public boolean hasErrorResults() {
        return this.myErrorCount != 0;
    }

    public int size() {
        return this.myInfos.size();
    }

    @NotNull
    public HighlightInfo get(int i) {
        HighlightInfo highlightInfo = this.myInfos.get(i);
        if (highlightInfo == null) {
            HighlightInfoHolder.$$$reportNull$$$0(3);
        }
        return highlightInfo;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myContextFile.getProject();
        if (project == null) {
            HighlightInfoHolder.$$$reportNull$$$0(4);
        }
        return project;
    }

    @NotNull
    public PsiFile getContextFile() {
        PsiFile psiFile = this.myContextFile;
        if (psiFile == null) {
            HighlightInfoHolder.$$$reportNull$$$0(5);
        }
        return psiFile;
    }

    private boolean accepted(@NotNull HighlightInfo info) {
        if (info == null) {
            HighlightInfoHolder.$$$reportNull$$$0(6);
        }
        for (HighlightInfoFilter filter2 : this.myFilters) {
            if (filter2.accept(info, this.getContextFile())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public TextAttributesScheme getColorsScheme() {
        TextAttributesScheme textAttributesScheme = key -> key.getDefaultAttributes();
        if (textAttributesScheme == null) {
            HighlightInfoHolder.$$$reportNull$$$0(7);
        }
        return textAttributesScheme;
    }

    public String toString() {
        return "HighlightInfoHolder{" + this.size() + " results}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationSession";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorsScheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accepted";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 7 -> new IllegalStateException(string);
        };
    }
}

