/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class UsedColors {
    private static final Key<Object> USED_COLOR = Key.create("USED_COLOR");

    public static int getOrAddColorIndex(@NotNull UserDataHolderEx context, @NotNull String name, int colorsCount) {
        int colorIndex;
        Object data;
        UsedColor[] newColors;
        if (context == null) {
            UsedColors.$$$reportNull$$$0(0);
        }
        if (name == null) {
            UsedColors.$$$reportNull$$$0(1);
        }
        do {
            UsedColor[] usedColors;
            int hashedIndex;
            if ((data = context.getUserData(USED_COLOR)) == null) {
                colorIndex = UsedColors.hashColor(name, colorsCount);
                newColors = new UsedColor(name, colorIndex);
                continue;
            }
            if (data instanceof UsedColor) {
                UsedColor usedColor = (UsedColor)data;
                if (usedColor.name.equals(name)) {
                    colorIndex = usedColor.index;
                    newColors = null;
                    continue;
                }
                hashedIndex = UsedColors.hashColor(name, colorsCount);
                if (hashedIndex == usedColor.index) {
                    hashedIndex = (hashedIndex + 1) % colorsCount;
                }
                colorIndex = hashedIndex;
                UsedColor newColor = new UsedColor(name, colorIndex);
                newColors = new UsedColor[]{usedColor, newColor};
                continue;
            }
            colorIndex = -1;
            hashedIndex = UsedColors.hashColor(name, colorsCount);
            int[] index2usage = new int[colorsCount];
            for (UsedColor usedColor : usedColors = (UsedColor[])data) {
                int index;
                int n = index = usedColor.index;
                index2usage[n] = index2usage[n] + 1;
                if (!usedColor.name.equals(name)) continue;
                colorIndex = index;
                break;
            }
            if (colorIndex == -1) {
                int minIndex2;
                int minIndex1 = UsedColors.indexOfMin(index2usage, hashedIndex, colorsCount);
                colorIndex = index2usage[minIndex1] <= index2usage[minIndex2 = UsedColors.indexOfMin(index2usage, 0, hashedIndex)] ? minIndex1 : minIndex2;
                UsedColor newColor = new UsedColor(name, colorIndex);
                newColors = ArrayUtil.append(usedColors, newColor);
                continue;
            }
            newColors = null;
        } while (newColors != null && !context.replace(USED_COLOR, data, newColors));
        return colorIndex;
    }

    private static int hashColor(@NotNull String name, int colorsCount) {
        if (name == null) {
            UsedColors.$$$reportNull$$$0(2);
        }
        return Math.abs(StringHash.murmur(name, 21930) % colorsCount);
    }

    @Contract(pure=true)
    private static int indexOfMin(int @NotNull [] values2, int start, int end) {
        if (values2 == null) {
            UsedColors.$$$reportNull$$$0(3);
        }
        int min = Integer.MAX_VALUE;
        int minIndex = start;
        for (int i = start; i < end; ++i) {
            int value = values2[i];
            if (value >= min) continue;
            min = value;
            minIndex = i;
        }
        return minIndex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/UsedColors";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrAddColorIndex";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hashColor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "indexOfMin";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private record UsedColor(@NotNull String name, int index) {
        @NotNull
        private final String name;

        private UsedColor(@NotNull String name, int index) {
            if (name == null) {
                UsedColor.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public String name() {
            String string = this.name;
            if (string == null) {
                UsedColor.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/UsedColors$UsedColor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/UsedColors$UsedColor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

