/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.TailTypes;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.CompletionVariant;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.PresentableLookupValue;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.patterns.CharPattern;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferencesWrapper;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.TrueFilter;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@Deprecated(forRemoval=true)
public class CompletionData {
    private static final Logger LOG = Logger.getInstance(CompletionData.class);
    public static final ObjectPattern.Capture<Character> NOT_JAVA_ID = StandardPatterns.not(CharPattern.javaIdentifierPartCharacter());
    public static final Key<PsiReference> LOOKUP_ELEMENT_PSI_REFERENCE = Key.create("lookup element psi reference");
    private final List<CompletionVariant> myCompletionVariants = new ArrayList<CompletionVariant>();
    protected final CompletionVariant myGenericVariant = new CompletionVariant(){

        @Override
        void addReferenceCompletions(PsiReference reference, PsiElement position, Set<? super LookupElement> set, PsiFile file, CompletionData completionData) {
            CompletionData.this.completeReference(reference, position, set, TailTypes.noneType(), TrueFilter.INSTANCE, this);
        }
    };

    protected CompletionData() {
    }

    private boolean isScopeAcceptable(PsiElement scope) {
        for (CompletionVariant variant : this.myCompletionVariants) {
            if (!variant.isScopeAcceptable(scope)) continue;
            return true;
        }
        return false;
    }

    @Deprecated(forRemoval=true)
    protected void registerVariant(CompletionVariant variant) {
        this.myCompletionVariants.add(variant);
    }

    public void completeReference(PsiReference reference, Set<? super LookupElement> set, @NotNull PsiElement position, PsiFile file) {
        if (position == null) {
            CompletionData.$$$reportNull$$$0(0);
        }
        CompletionVariant[] variants = this.findVariants(position, file);
        boolean hasApplicableVariants = false;
        for (CompletionVariant variant : variants) {
            if (!variant.hasReferenceFilter()) continue;
            variant.addReferenceCompletions(reference, position, set, file, this);
            hasApplicableVariants = true;
        }
        if (!hasApplicableVariants) {
            this.myGenericVariant.addReferenceCompletions(reference, position, set, file, this);
        }
    }

    public void addKeywordVariants(Set<? super CompletionVariant> set, PsiElement position, PsiFile file) {
        ContainerUtil.addAll(set, this.findVariants(position, file));
    }

    void completeKeywordsBySet(Set<LookupElement> set, Set<? extends CompletionVariant> variants) {
        for (CompletionVariant completionVariant : variants) {
            completionVariant.addKeywords(set, this);
        }
    }

    public String findPrefix(PsiElement insertedElement, int offsetInFile) {
        return CompletionData.findPrefixStatic(insertedElement, offsetInFile);
    }

    public CompletionVariant[] findVariants(PsiElement position, PsiFile file) {
        ArrayList<CompletionVariant> variants = new ArrayList<CompletionVariant>();
        PsiElement scope = position;
        if (scope == null) {
            scope = file;
        }
        while (scope != null) {
            boolean breakFlag = false;
            if (this.isScopeAcceptable(scope)) {
                for (CompletionVariant variant : this.myCompletionVariants) {
                    if (!variant.isVariantApplicable(position, scope) || variants.contains(variant)) continue;
                    variants.add(variant);
                    if (!variant.isScopeFinal(scope)) continue;
                    breakFlag = true;
                }
            }
            if (!breakFlag && !((scope = scope.getContext()) instanceof PsiDirectory)) continue;
            break;
        }
        return variants.toArray(new CompletionVariant[0]);
    }

    private static String findPrefixStatic(PsiElement insertedElement, int offsetInFile, ElementPattern<Character> prefixStartTrim) {
        if (insertedElement == null) {
            return "";
        }
        Document document = insertedElement.getContainingFile().getViewProvider().getDocument();
        assert (document != null);
        LOG.assertTrue(!PsiDocumentManager.getInstance(insertedElement.getProject()).isUncommited(document), "Uncommitted");
        String prefix = CompletionUtil.findReferencePrefix(insertedElement, offsetInFile);
        if (prefix != null) {
            return prefix;
        }
        if (insertedElement.getTextRange().equals(insertedElement.getContainingFile().getTextRange()) || insertedElement instanceof PsiComment) {
            return CompletionUtil.findJavaIdentifierPrefix(insertedElement, offsetInFile);
        }
        return CompletionData.findPrefixDefault(insertedElement, offsetInFile, prefixStartTrim);
    }

    @Deprecated(forRemoval=true)
    public static String findPrefixStatic(PsiElement insertedElement, int offsetInFile) {
        return CompletionData.findPrefixStatic(insertedElement, offsetInFile, NOT_JAVA_ID);
    }

    private static String findPrefixDefault(PsiElement insertedElement, int offset, @NotNull ElementPattern trimStart) {
        int i;
        String substr;
        if (trimStart == null) {
            CompletionData.$$$reportNull$$$0(1);
        }
        if ((substr = insertedElement.getText().substring(0, offset - insertedElement.getTextRange().getStartOffset())).isEmpty() || Character.isWhitespace(substr.charAt(substr.length() - 1))) {
            return "";
        }
        substr = substr.trim();
        for (i = 0; substr.length() > i && trimStart.accepts(Character.valueOf(substr.charAt(i))); ++i) {
        }
        return substr.substring(i).trim();
    }

    @NotNull
    public static LookupElement objectToLookupItem(@NotNull Object object) {
        if (object == null) {
            CompletionData.$$$reportNull$$$0(2);
        }
        if (object instanceof LookupElement) {
            LookupElement lookupElement;
            LookupElement lookupElement2 = lookupElement = (LookupElement)object;
            if (lookupElement2 == null) {
                CompletionData.$$$reportNull$$$0(3);
            }
            return lookupElement2;
        }
        String s = null;
        TailType tailType = TailTypes.noneType();
        if (object instanceof PsiElement) {
            PsiElement psiElement = (PsiElement)object;
            s = PsiUtilCore.getName(psiElement);
        } else if (object instanceof PsiMetaData) {
            PsiMetaData metaData = (PsiMetaData)object;
            s = metaData.getName();
        } else if (object instanceof String) {
            String string;
            s = string = (String)object;
        } else if (object instanceof PresentableLookupValue) {
            PresentableLookupValue lookupValue = (PresentableLookupValue)object;
            s = lookupValue.getPresentation();
        }
        if (s == null) {
            throw PluginException.createByClass("Null string for object: " + String.valueOf(object) + " of " + String.valueOf(object.getClass()), null, object.getClass());
        }
        LookupItem<Object> item = new LookupItem<Object>(object, s);
        item.setAttribute(LookupItem.TAIL_TYPE_ATTR, (Object)tailType);
        LookupItem<Object> lookupItem = item;
        if (lookupItem == null) {
            CompletionData.$$$reportNull$$$0(4);
        }
        return lookupItem;
    }

    protected void addLookupItem(Set<? super LookupElement> set, TailType tailType, @NotNull Object completion, CompletionVariant variant) {
        LookupElement ret;
        if (completion == null) {
            CompletionData.$$$reportNull$$$0(5);
        }
        if (!((ret = CompletionData.objectToLookupItem(completion)) instanceof LookupItem)) {
            set.add(ret);
            return;
        }
        LookupItem item = (LookupItem)ret;
        InsertHandler insertHandler = variant.getInsertHandler();
        if (insertHandler != null && item.getInsertHandler() == null) {
            item.setInsertHandler(insertHandler);
            item.setTailType(TailTypes.unknownType());
        } else if (tailType != TailTypes.noneType()) {
            item.setTailType(tailType);
        }
        Map<Object, Object> itemProperties = variant.getItemProperties();
        for (Object key : itemProperties.keySet()) {
            item.setAttribute(key, itemProperties.get(key));
        }
        set.add(ret);
    }

    protected void completeReference(PsiReference reference, PsiElement position, Set<? super LookupElement> set, TailType tailType, ElementFilter filter2, CompletionVariant variant) {
        if (reference instanceof PsiMultiReference) {
            PsiMultiReference multiReference = (PsiMultiReference)reference;
            for (PsiReference ref : CompletionData.getReferences(multiReference)) {
                this.completeReference(ref, position, set, tailType, filter2, variant);
            }
        } else if (reference instanceof PsiReferencesWrapper) {
            PsiReferencesWrapper wrapper = (PsiReferencesWrapper)((Object)reference);
            for (PsiReference ref : wrapper.getReferences()) {
                this.completeReference(ref, position, set, tailType, filter2, variant);
            }
        } else {
            Object[] completions = reference.getVariants();
            CompletionData.putSourceInformation(reference, completions);
            for (Object completion : completions) {
                LookupItem lookupItem;
                Object o;
                if (completion == null) {
                    LOG.error("Position=" + String.valueOf(position) + "\n;Reference=" + String.valueOf(reference) + "\n;variants=" + Arrays.toString(completions));
                    continue;
                }
                if (completion instanceof PsiElement) {
                    PsiElement psiElement = (PsiElement)completion;
                    if (!filter2.isClassAcceptable(psiElement.getClass()) || !filter2.isAcceptable(psiElement, position)) continue;
                    this.addLookupItem(set, tailType, completion, variant);
                    continue;
                }
                if (completion instanceof LookupItem && (o = (lookupItem = (LookupItem)completion).getObject()) instanceof PsiElement && (!filter2.isClassAcceptable(o.getClass()) || !filter2.isAcceptable(o, position))) continue;
                try {
                    this.addLookupItem(set, tailType, completion, variant);
                }
                catch (AssertionError e) {
                    LOG.error("Caused by variant from reference: " + String.valueOf(reference.getClass()), (Throwable)((Object)e));
                }
            }
        }
    }

    private static void putSourceInformation(@NotNull PsiReference reference, Object[] referencesAsObjects) {
        if (reference == null) {
            CompletionData.$$$reportNull$$$0(6);
        }
        for (Object referenceAsObject : referencesAsObjects) {
            if (!(referenceAsObject instanceof UserDataHolderBase)) continue;
            UserDataHolderBase userDataHolderBaseReference = (UserDataHolderBase)referenceAsObject;
            userDataHolderBaseReference.putUserData(LOOKUP_ELEMENT_PSI_REFERENCE, reference);
        }
    }

    protected static PsiReference[] getReferences(PsiMultiReference multiReference) {
        PsiReference[] references = multiReference.getReferences();
        List<PsiReference> hard = ContainerUtil.findAll(references, object -> !object.isSoft());
        if (!hard.isEmpty()) {
            return hard.toArray(PsiReference.EMPTY_ARRAY);
        }
        return references;
    }

    void addKeywords(Set<LookupElement> set, CompletionVariant variant, Object comp, TailType tailType) {
        if (!(comp instanceof String)) {
            return;
        }
        for (LookupElement item : set) {
            if (!item.getObject().toString().equals(comp)) continue;
            return;
        }
        this.addLookupItem(set, tailType, comp, variant);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trimStart";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/CompletionData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completion";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/CompletionData";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "objectToLookupItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "completeReference";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findPrefixDefault";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "objectToLookupItem";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addLookupItem";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "putSourceInformation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

