/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/checks/DataBindingDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "<init>", "()V", "getApplicableAttributes", "", "", "visitAttribute", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "attribute", "Lorg/w3c/dom/Attr;", "isVariableType", "", "elementName", "attributeName", "Companion", "lint-checks"})
public final class DataBindingDetector
extends LayoutDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue ESCAPE_XML = Issue.Companion.create("XmlEscapeNeeded", "Missing XML Escape", "\n              When a string contains characters that have special usage in XML, \\\n              you must escape the characters.\n            ", Category.CORRECTNESS, 5, Severity.ERROR, new Implementation(DataBindingDetector.class, Scope.RESOURCE_FILE_SCOPE));

    @NotNull
    public Collection<String> getApplicableAttributes() {
        List list = LayoutDetector.ALL;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ALL");
        return list;
    }

    public void visitAttribute(@NotNull XmlContext context, @NotNull Attr attribute) {
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
                String elementName = attribute.getOwnerElement().getTagName();
                String attributeName = attribute.getName();
                String string2 = attribute.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
                if (Lint.isDataBindingExpression((String)string2)) break block7;
                Intrinsics.checkNotNull((Object)elementName);
                Intrinsics.checkNotNull((Object)attributeName);
                if (!this.isVariableType(elementName, attributeName)) break block8;
            }
            CharSequence charSequence = context.getContents();
            if (charSequence == null) {
                return;
            }
            CharSequence rawText = charSequence;
            int start = context.getParser().getNodeStartOffset(context, (Node)attribute);
            if (start == -1) {
                return;
            }
            int end = Integer.min(rawText.length(), context.getParser().getNodeEndOffset(context, (Node)attribute));
            boolean isContained = false;
            for (int index2 = start; index2 < end; ++index2) {
                if (rawText.charAt(index2) != '<') continue;
                isContained = true;
                break;
            }
            if (isContained) {
                LintFix fix2 = this.fix().name("Change '<' to '&lt;'").replace().text("<").with("&lt;").build();
                context.report(ESCAPE_XML, (Node)attribute, context.getValueLocation(attribute), "`<` must be escaped (as `&lt;`) in attribute values", fix2);
            }
        }
    }

    private final boolean isVariableType(String elementName, String attributeName) {
        return Intrinsics.areEqual((Object)elementName, (Object)"variable") && Intrinsics.areEqual((Object)attributeName, (Object)"type");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/lint/checks/DataBindingDetector$Companion;", "", "<init>", "()V", "ESCAPE_XML", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

