/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.SdkInfo;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.DomExtensions;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010\r\u001a\u00020\b*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\u000e\u001a\u00020\b*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/checks/ChildInNonViewGroupDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "<init>", "()V", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "explore", "reportWrongParent", "isChildOfViewGroup", "", "Lcom/android/tools/lint/client/api/SdkInfo;", "Issues", "lint-checks"})
public final class ChildInNonViewGroupDetector
extends LayoutDetector {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(ChildInNonViewGroupDetector.class, Scope.RESOURCE_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue CHILD_IN_NON_VIEW_GROUP_ISSUE = Issue.Companion.create("ChildInNonViewGroup", "Only view groups can have children", "\n            Only classes inheriting from `ViewGroup` can have children.\n            ", Category.CORRECTNESS, 8, Severity.ERROR, IMPLEMENTATION);

    @NotNull
    public Collection<String> getApplicableElements() {
        List list = LayoutDetector.ALL;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ALL");
        return list;
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.explore(context, element);
    }

    private final void explore(XmlContext $this$explore, Element element) {
        if (Lint.isLayoutMarkerTag((Element)element)) {
            return;
        }
        Iterator iterator = DomExtensions.iterator((Element)element);
        while (iterator.hasNext()) {
            Element child = (Element)iterator.next();
            if (Lint.isLayoutMarkerTag((Element)child) || this.isChildOfViewGroup($this$explore.getSdkInfo(), child)) continue;
            this.reportWrongParent($this$explore, child);
        }
    }

    private final void reportWrongParent(XmlContext $this$reportWrongParent, Element element) {
        XmlContext.report$default((XmlContext)$this$reportWrongParent, (Issue)CHILD_IN_NON_VIEW_GROUP_ISSUE, (Node)element, (Location)$this$reportWrongParent.getNameLocation((Node)element), (String)("A " + element.getParentNode().getNodeName() + " should have no children declared in XML"), null, (int)16, null);
    }

    private final boolean isChildOfViewGroup(SdkInfo $this$isChildOfViewGroup, Element element) {
        String string2 = element.getParentNode().getNodeName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getNodeName(...)");
        return $this$isChildOfViewGroup.isSubViewOf("ViewGroup", string2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/lint/checks/ChildInNonViewGroupDetector$Issues;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "CHILD_IN_NON_VIEW_GROUP_ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

