/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.sources;

import com.android.io.CancellableFileIo;
import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepositorySource;
import com.android.repository.api.RepositorySourceProvider;
import com.android.repository.api.SchemaModule;
import com.android.repository.api.SimpleRepositorySource;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public class LocalSourceProvider
implements RepositorySourceProvider {
    private static final String KEY_COUNT = "count";
    private static final String KEY_SRC = "src";
    private static final String KEY_DISPLAY = "disp";
    private static final String KEY_ENABLED = "enabled";
    private final Path mLocation;
    private List<RepositorySource> mSources;
    private static final Object LOCK = new Object();
    private final Collection<SchemaModule<?>> mAllowedModules;
    private final Collection<SchemaModule<?>> mAllowedGoogleModules;
    private RepoManager mRepoManager;

    public LocalSourceProvider(Path location, Collection<SchemaModule<?>> allowedModules, Collection<SchemaModule<?>> allowedGoogleModules) {
        this.mAllowedModules = allowedModules;
        this.mAllowedGoogleModules = allowedGoogleModules;
        this.mLocation = location;
    }

    public void setRepoManager(RepoManager manager) {
        this.mRepoManager = manager;
    }

    public Collection<SchemaModule<?>> getAllowedModulesBasedOnUrl(String url) {
        boolean isGoogleUrl = url.startsWith("https://dl.google.com/");
        return isGoogleUrl ? this.mAllowedGoogleModules : this.mAllowedModules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUserAddons(ProgressIndicator progress) {
        assert (this.mRepoManager != null);
        Object object = LOCK;
        synchronized (object) {
            ArrayList result = Lists.newArrayList();
            try (InputStream fis2 = CancellableFileIo.newInputStream((Path)this.mLocation, (OpenOption[])new OpenOption[0]);){
                Properties props = new Properties();
                props.load(fis2);
                int count = Integer.parseInt(props.getProperty(KEY_COUNT, "0"));
                for (int i = 0; i < count; ++i) {
                    String url = props.getProperty(String.format(Locale.US, "%s%02d", KEY_SRC, i));
                    String disp = props.getProperty(String.format(Locale.US, "%s%02d", KEY_DISPLAY, i));
                    String enabledStr = props.getProperty(String.format(Locale.US, "%s%02d", KEY_ENABLED, i));
                    boolean enabled = enabledStr == null ? true : Boolean.parseBoolean(enabledStr);
                    if (url == null) continue;
                    Collection<SchemaModule<?>> allowedModules = this.getAllowedModulesBasedOnUrl(url);
                    result.add(new SimpleRepositorySource(url, disp, enabled, allowedModules, this));
                }
            }
            catch (NoSuchFileException fis2) {
            }
            catch (IOException | NumberFormatException e) {
                progress.logWarning("Failed to parse user addon file at " + String.valueOf(this.mLocation), e);
            }
            if (this.mSources == null) {
                this.mSources = Lists.newArrayList((Iterable)result);
            } else {
                this.mSources.clear();
                this.mSources.addAll(result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RepositorySource> getSources(Downloader downloader, ProgressIndicator logger, boolean forceRefresh) {
        Object object = LOCK;
        synchronized (object) {
            if (this.mSources == null || forceRefresh) {
                this.loadUserAddons(logger);
            }
        }
        return ImmutableList.copyOf(this.mSources);
    }

    @Override
    public boolean addSource(RepositorySource source) {
        boolean result = this.mSources.add(source);
        this.mRepoManager.markInvalid();
        return result;
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(ProgressIndicator progress) {
        Object object = LOCK;
        synchronized (object) {
            try (OutputStream fos = Files.newOutputStream(this.mLocation, new OpenOption[0]);){
                Properties props = new Properties();
                int count = 0;
                for (RepositorySource s : this.mSources) {
                    props.setProperty(String.format(Locale.US, "%s%02d", KEY_SRC, count), s.getUrl());
                    if (s.getDisplayName() != null) {
                        props.setProperty(String.format(Locale.US, "%s%02d", KEY_DISPLAY, count), s.getDisplayName());
                    }
                    props.setProperty(String.format(Locale.US, "%s%02d", KEY_ENABLED, count), Boolean.toString(s.isEnabled()));
                    ++count;
                }
                props.setProperty(KEY_COUNT, Integer.toString(count));
                props.store(fos, "## User Sources for Android Repository");
            }
            catch (IOException e) {
                progress.logWarning("failed to save sites", e);
            }
        }
    }

    @Override
    public boolean removeSource(RepositorySource source) {
        boolean result = this.mSources.remove(source);
        this.mRepoManager.markInvalid();
        return result;
    }
}

